/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domimpl.html;

import java.util.Iterator;
import java.util.LinkedList;
import org.itsnat.impl.core.domimpl.DocumentImpl;
import org.itsnat.impl.core.domimpl.html.HTMLCollectionImpl;
import org.itsnat.impl.core.domimpl.html.HTMLElementImpl;
import org.itsnat.impl.core.domimpl.html.HTMLTableElementImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class HTMLTableRowElementImpl
extends HTMLElementImpl
implements HTMLTableRowElement {
    protected HTMLCollection cells;

    protected HTMLTableRowElementImpl() {
    }

    public HTMLTableRowElementImpl(String name, DocumentImpl owner) {
        super(name, owner);
    }

    @Override
    protected HTMLElementImpl newHTMLElement() {
        return new HTMLTableRowElementImpl();
    }

    @Override
    public String getAlign() {
        return this.getAttribute("align");
    }

    @Override
    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    @Override
    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    @Override
    public void setBgColor(String bgColor) {
        this.setAttribute("bgcolor", bgColor);
    }

    @Override
    public String getCh() {
        return this.getAttribute("char");
    }

    @Override
    public void setCh(String ch) {
        this.setAttribute("char", ch);
    }

    @Override
    public String getChOff() {
        return this.getAttribute("charoff");
    }

    @Override
    public void setChOff(String chOff) {
        this.setAttribute("charoff", chOff);
    }

    @Override
    public String getVAlign() {
        return this.getAttribute("valign");
    }

    @Override
    public void setVAlign(String vAlign) {
        this.setAttribute("valign", vAlign);
    }

    @Override
    public int getRowIndex() {
        HTMLTableSectionElement section = (HTMLTableSectionElement)this.getParentNode();
        HTMLTableElement table = (HTMLTableElement)section.getParentNode();
        LinkedList<Node> rows = HTMLTableElementImpl.getRowsArray(table);
        int i = 0;
        Iterator it = rows.iterator();
        while (it.hasNext()) {
            if (it.next() == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setRowIndex(int rowIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getSectionRowIndex() {
        HTMLTableSectionElement section = (HTMLTableSectionElement)this.getParentNode();
        LinkedList<Node> rows = DOMUtilInternal.getChildElementListWithTagNameNS(section, "http://www.w3.org/1999/xhtml", "tr", false);
        int i = 0;
        Iterator it = rows.iterator();
        while (it.hasNext()) {
            if (it.next() == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setSectionRowIndex(int sectionRowIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public HTMLCollection getCells() {
        if (this.cells == null) {
            this.cells = new HTMLCollectionImpl(this, -3);
        }
        return this.cells;
    }

    public void setCells(HTMLCollection cells) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public LinkedList<Node> getCellsArray() {
        LinkedList<Node> cells;
        LinkedList<Node> thCells = this.getChildrenArray("th", false);
        LinkedList<Node> tdCells = this.getChildrenArray("td", false);
        if (thCells != null && tdCells != null) {
            cells = new LinkedList();
            cells.addAll(thCells);
            cells.addAll(tdCells);
        } else {
            cells = thCells != null ? thCells : (tdCells != null ? tdCells : null);
        }
        return cells;
    }

    @Override
    public HTMLElement insertCell(int index) {
        LinkedList<Node> cells = this.getCellsArray();
        return this.insertElement(index, "td", cells);
    }

    @Override
    public void deleteCell(int index) {
        LinkedList<Node> cells = this.getCellsArray();
        this.deleteElement(index, cells);
    }
}

