/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domimpl.html;

import java.util.LinkedList;
import org.itsnat.core.domutil.ItsNatTreeWalker;
import org.itsnat.impl.core.domimpl.DocumentImpl;
import org.itsnat.impl.core.domimpl.html.HTMLCollectionImpl;
import org.itsnat.impl.core.domimpl.html.HTMLElementImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCaptionElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class HTMLTableElementImpl
extends HTMLElementImpl
implements HTMLTableElement {
    protected HTMLCollection rows;
    protected HTMLCollection bodies;

    protected HTMLTableElementImpl() {
    }

    public HTMLTableElementImpl(String name, DocumentImpl owner) {
        super(name, owner);
    }

    @Override
    protected HTMLElementImpl newHTMLElement() {
        return new HTMLTableElementImpl();
    }

    @Override
    public String getAlign() {
        return this.getAttribute("align");
    }

    @Override
    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    @Override
    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    @Override
    public void setBgColor(String bgColor) {
        this.setAttribute("bgcolor", bgColor);
    }

    @Override
    public String getBorder() {
        return this.getAttribute("border");
    }

    @Override
    public void setBorder(String border) {
        this.setAttribute("border", border);
    }

    @Override
    public String getCellPadding() {
        return this.getAttribute("cellpadding");
    }

    @Override
    public void setCellPadding(String cellPadding) {
        this.setAttribute("cellpadding", cellPadding);
    }

    @Override
    public String getCellSpacing() {
        return this.getAttribute("cellspacing");
    }

    @Override
    public void setCellSpacing(String cellSpacing) {
        this.setAttribute("cellspacing", cellSpacing);
    }

    @Override
    public String getFrame() {
        return this.getAttribute("frame");
    }

    @Override
    public void setFrame(String frame) {
        this.setAttribute("frame", frame);
    }

    @Override
    public String getRules() {
        return this.getAttribute("rules");
    }

    @Override
    public void setRules(String rules) {
        this.setAttribute("rules", rules);
    }

    @Override
    public String getSummary() {
        return this.getAttribute("summary");
    }

    @Override
    public void setSummary(String summary) {
        this.setAttribute("summary", summary);
    }

    @Override
    public String getWidth() {
        return this.getAttribute("width");
    }

    @Override
    public void setWidth(String width) {
        this.setAttribute("width", width);
    }

    @Override
    public HTMLTableCaptionElement getCaption() {
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof HTMLTableCaptionElement)) continue;
            return (HTMLTableCaptionElement)child;
        }
        return null;
    }

    @Override
    public void setCaption(HTMLTableCaptionElement caption) {
        HTMLTableCaptionElement current = this.getCaption();
        if (current != null) {
            if (current == caption) {
                return;
            }
            Node next = current.getNextSibling();
            this.removeChild(current);
            this.insertBefore(caption, next);
        } else {
            this.insertBefore(caption, this.getFirstChild());
        }
    }

    @Override
    public HTMLElement createCaption() {
        HTMLTableCaptionElement caption = this.getCaption();
        if (caption != null) {
            return caption;
        }
        caption = (HTMLTableCaptionElement)this.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "caption");
        this.setCaption(caption);
        return caption;
    }

    @Override
    public void deleteCaption() {
        HTMLTableCaptionElement caption = this.getCaption();
        if (caption != null) {
            this.removeChild(caption);
        }
    }

    public HTMLTableSectionElement getTableSection(String localName) {
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof HTMLTableSectionElement) || !child.getLocalName().equals(localName)) continue;
            return (HTMLTableSectionElement)child;
        }
        return null;
    }

    public void deleteTableSection(String localName) {
        HTMLTableSectionElement section = this.getTableSection(localName);
        if (section != null) {
            this.removeChild(section);
        }
    }

    public void setTableSection(HTMLTableSectionElement section, String localName) {
        if (section != null && !section.getLocalName().equals(localName)) {
            throw new IllegalArgumentException("Argument is not an element of type <" + localName + ">.");
        }
        HTMLTableSectionElement current = this.getTableSection(localName);
        if (current != null) {
            if (current == section) {
                return;
            }
            Node next = current.getNextSibling();
            this.removeChild(current);
            this.insertBefore(section, next);
        } else if (localName.equals("thead")) {
            HTMLTableSectionElement tfoot = this.getTFoot();
            if (tfoot != null) {
                this.insertBefore(section, tfoot);
            } else {
                HTMLTableSectionElement tbody = this.getTableSection("tbody");
                if (tbody != null) {
                    this.insertBefore(section, tbody);
                } else {
                    this.appendChild(section);
                }
            }
        } else if (localName.equals("tfoot")) {
            HTMLTableSectionElement tbody = this.getTableSection("tbody");
            if (tbody != null) {
                this.insertBefore(section, tbody);
            } else {
                this.appendChild(section);
            }
        }
    }

    public HTMLTableSectionElement createTableSection(String localName) {
        HTMLTableSectionElement section = this.getTableSection(localName);
        if (section != null) {
            return section;
        }
        section = (HTMLTableSectionElement)this.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", localName);
        this.setTableSection(section, localName);
        return section;
    }

    @Override
    public HTMLTableSectionElement getTHead() {
        return this.getTableSection("thead");
    }

    @Override
    public void setTHead(HTMLTableSectionElement tHead) {
        this.setTableSection(tHead, "thead");
    }

    @Override
    public HTMLElement createTHead() {
        return this.createTableSection("thead");
    }

    @Override
    public void deleteTHead() {
        this.deleteTableSection("thead");
    }

    @Override
    public HTMLTableSectionElement getTFoot() {
        return this.getTableSection("tfood");
    }

    @Override
    public void setTFoot(HTMLTableSectionElement tFoot) {
        this.setTableSection(tFoot, "tfood");
    }

    @Override
    public HTMLElement createTFoot() {
        return this.createTableSection("tfood");
    }

    @Override
    public void deleteTFoot() {
        this.deleteTableSection("tfood");
    }

    @Override
    public HTMLCollection getRows() {
        if (this.rows == null) {
            this.rows = new HTMLCollectionImpl(this, 7);
        }
        return this.rows;
    }

    @Override
    public HTMLCollection getTBodies() {
        if (this.bodies == null) {
            this.bodies = new HTMLCollectionImpl(this, -2);
        }
        return this.bodies;
    }

    public static LinkedList<Node> getRowsArray(HTMLTableElement table) {
        LinkedList<Node> total = null;
        Element section = ItsNatTreeWalker.getFirstChildElement(table);
        while (section != null) {
            LinkedList<Node> rows;
            if (section instanceof HTMLTableSectionElement && (rows = DOMUtilInternal.getChildElementListWithTagNameNS(section, "http://www.w3.org/1999/xhtml", "tr", false)) != null) {
                if (total == null) {
                    total = new LinkedList<Node>();
                }
                total.addAll(rows);
            }
            section = ItsNatTreeWalker.getNextSiblingElement(section);
        }
        return total;
    }

    public LinkedList<Node> getRowsArray() {
        return HTMLTableElementImpl.getRowsArray(this);
    }

    public HTMLTableRowElement getHTMLTableRowElement(int index) {
        return (HTMLTableRowElement)DOMUtilInternal.getChildElementWithTagNameNS(this, "http://www.w3.org/1999/xhtml", "tr", index);
    }

    @Override
    public HTMLElement insertRow(int index) {
        if (index < 0) {
            throw new DOMException(1, "Index is negative");
        }
        HTMLTableRowElement newRow = (HTMLTableRowElement)this.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "tr");
        LinkedList<Node> rows = this.getRowsArray();
        if (rows != null) {
            int len = rows.size();
            if (index > len) {
                throw new DOMException(1, "Index " + index + " is greater than the number of rows: " + len);
            }
            if (index < len) {
                HTMLTableRowElement rowRef = (HTMLTableRowElement)rows.get(index);
                rowRef.getParentNode().insertBefore(newRow, rowRef);
            } else {
                HTMLTableSectionElement tbody = (HTMLTableSectionElement)this.getTBodies().item(0);
                if (tbody == null) {
                    tbody = (HTMLTableSectionElement)this.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "tbody");
                    this.appendChild(tbody);
                }
                tbody.appendChild(newRow);
            }
        } else {
            if (index > 0) {
                throw new DOMException(1, "Index " + index + " is greater than the number of rows: 0");
            }
            HTMLTableSectionElement tbody = (HTMLTableSectionElement)this.getTBodies().item(0);
            if (tbody == null) {
                tbody = (HTMLTableSectionElement)this.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "tbody");
                this.appendChild(tbody);
            }
            tbody.appendChild(newRow);
        }
        return newRow;
    }

    @Override
    public void deleteRow(int index) {
        LinkedList<Node> rows = this.getRowsArray();
        this.deleteElement(index, rows);
    }
}

