/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domimpl.html;

import java.util.LinkedList;
import org.itsnat.impl.core.domimpl.DocumentImpl;
import org.itsnat.impl.core.domimpl.html.HTMLCollectionImpl;
import org.itsnat.impl.core.domimpl.html.HTMLElementImpl;
import org.itsnat.impl.core.domimpl.html.HTMLOptionElementImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLFormElement;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLSelectElement;

public class HTMLSelectElementImpl
extends HTMLElementImpl
implements HTMLSelectElement {
    protected HTMLCollection options;

    protected HTMLSelectElementImpl() {
    }

    public HTMLSelectElementImpl(String name, DocumentImpl owner) {
        super(name, owner);
    }

    @Override
    protected HTMLElementImpl newHTMLElement() {
        return new HTMLSelectElementImpl();
    }

    public HTMLOptionElement getOptionElement(int index) {
        return (HTMLOptionElement)DOMUtilInternal.getChildElementWithTagNameNS(this, "http://www.w3.org/1999/xhtml", "option", index);
    }

    public static LinkedList<Node> getOptionsArray(HTMLSelectElement select) {
        return DOMUtilInternal.getChildElementListWithTagNameNS(select, "http://www.w3.org/1999/xhtml", "option", true);
    }

    public LinkedList<Node> getOptionsArray() {
        return HTMLSelectElementImpl.getOptionsArray(this);
    }

    @Override
    public String getType() {
        return this.getAttribute("type");
    }

    @Override
    public String getValue() {
        return this.getAttribute("value");
    }

    @Override
    public void setValue(String value) {
        this.setAttribute("value", value);
    }

    @Override
    public int getSelectedIndex() {
        LinkedList<Node> options = this.getOptionsArray();
        if (options != null) {
            int i = 0;
            for (HTMLOptionElement hTMLOptionElement : options) {
                if (hTMLOptionElement.getSelected()) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public void setSelectedIndex(int selectedIndex) {
        HTMLOptionElement optionSelected = null;
        LinkedList<Node> options = this.getOptionsArray();
        if (options != null) {
            int i = 0;
            for (HTMLOptionElement hTMLOptionElement : options) {
                if (i == selectedIndex) {
                    optionSelected = hTMLOptionElement;
                } else {
                    HTMLOptionElementImpl.setSelected(hTMLOptionElement, false);
                }
                ++i;
            }
        }
        if (optionSelected != null) {
            HTMLOptionElementImpl.setSelected(optionSelected, true);
        }
    }

    @Override
    public HTMLCollection getOptions() {
        if (this.options == null) {
            this.options = new HTMLCollectionImpl(this, 6);
        }
        return this.options;
    }

    @Override
    public int getLength() {
        return this.getOptions().getLength();
    }

    @Override
    public boolean getDisabled() {
        return this.getAttributeBoolean("disabled");
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.setAttributeBoolean("disabled", disabled);
    }

    @Override
    public boolean getMultiple() {
        return this.getAttributeBoolean("multiple");
    }

    @Override
    public void setMultiple(boolean multiple) {
        this.setAttributeBoolean("multiple", multiple);
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public int getSize() {
        return Integer.parseInt(this.getAttribute("size"));
    }

    @Override
    public void setSize(int size) {
        this.setAttribute("size", String.valueOf(size));
    }

    @Override
    public int getTabIndex() {
        return Integer.parseInt(this.getAttribute("tabindex"));
    }

    @Override
    public void setTabIndex(int tabIndex) {
        this.setAttribute("tabindex", String.valueOf(tabIndex));
    }

    @Override
    public void add(HTMLElement element, HTMLElement before) {
        this.insertBefore(element, before);
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            return;
        }
        HTMLOptionElement option = this.getOptionElement(index);
        if (option != null) {
            option.getParentNode().removeChild(option);
        }
    }

    @Override
    public void blur() {
        this.methodCallNoParam("blur");
    }

    @Override
    public void focus() {
        this.methodCallNoParam("focus");
    }

    @Override
    public HTMLFormElement getForm() {
        return this.getFormBase();
    }
}

