/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domimpl.html;

import java.util.LinkedList;
import org.apache.batik.dom.AbstractDocument;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.domimpl.DocumentImpl;
import org.itsnat.impl.core.domimpl.ElementNSImpl;
import org.itsnat.impl.core.domimpl.deleg.DelegateHTMLElementImpl;
import org.itsnat.impl.core.domimpl.deleg.DelegateNotDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLFormElement;

public abstract class HTMLElementImpl
extends ElementNSImpl
implements HTMLElement {
    protected HTMLElementImpl() {
    }

    public HTMLElementImpl(String name, DocumentImpl owner) {
        super("http://www.w3.org/1999/xhtml", name, (AbstractDocument)owner);
    }

    public Node newNode() {
        return this.newHTMLElement();
    }

    protected abstract HTMLElementImpl newHTMLElement();

    @Override
    public DelegateNotDocumentImpl createDelegateNotDocument() {
        return new DelegateHTMLElementImpl(this);
    }

    public DelegateHTMLElementImpl getDelegateHTMLElement() {
        return (DelegateHTMLElementImpl)this.getDelegateNode();
    }

    @Override
    public String getClassName() {
        return this.getAttribute("class");
    }

    @Override
    public void setClassName(String className) {
        this.setAttribute("class", className);
    }

    @Override
    public String getDir() {
        return this.getAttribute("dir");
    }

    @Override
    public void setDir(String dir) {
        this.setAttribute("dir", dir);
    }

    @Override
    public String getLang() {
        return this.getAttribute("lang");
    }

    @Override
    public void setLang(String lang) {
        this.setAttribute("lang", lang);
    }

    @Override
    public String getTitle() {
        return this.getAttribute("title");
    }

    @Override
    public void setTitle(String title) {
        this.setAttribute("title", title);
    }

    @Override
    public String getId() {
        return super.getId();
    }

    @Override
    public void setId(String id) {
        this.setAttribute("id", id);
    }

    public HTMLFormElement getFormBase() {
        for (Node parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!(parent instanceof HTMLFormElement)) continue;
            return (HTMLFormElement)parent;
        }
        return null;
    }

    @Override
    public String getTextContent() {
        StringBuilder text = new StringBuilder();
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Text)) continue;
            text.append(((Text)child).getData());
        }
        return text.toString();
    }

    @Override
    public void setTextContent(String text) {
        Node child = this.getFirstChild();
        if (child != null && child instanceof Text) {
            ((Text)child).setData(text);
        } else {
            if (child != null) {
                Node next;
                do {
                    next = child.getNextSibling();
                    this.removeChild(child);
                } while ((child = next) != null);
            }
            this.appendChild(this.getOwnerDocument().createTextNode(text));
        }
    }

    public LinkedList<Node> getChildrenArray(String localName, boolean recursive) {
        return DOMUtilInternal.getChildElementListWithTagNameNS(this, "http://www.w3.org/1999/xhtml", localName, recursive);
    }

    public HTMLElement insertElement(int index, String localName, boolean recursive) {
        return this.insertElement(index, localName, recursive, null);
    }

    public HTMLElement insertElement(int index, String localName, LinkedList<Node> children) {
        if (children == null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        return this.insertElement(index, localName, true, children);
    }

    private HTMLElement insertElement(int index, String localName, boolean recursive, LinkedList<Node> children) {
        if (index < 0) {
            throw new DOMException(1, "Index is negative");
        }
        HTMLElement newElem = (HTMLElement)this.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", localName);
        if (children == null) {
            children = this.getChildrenArray(localName, recursive);
        }
        if (children != null) {
            if (index > children.size()) {
                throw new DOMException(1, "Index " + index + " is greater than the number of rows: " + children.size());
            }
            HTMLElement elemRef = (HTMLElement)children.get(index);
            this.insertBefore(newElem, elemRef);
        } else {
            this.appendChild(newElem);
        }
        return newElem;
    }

    public void deleteElement(int index, LinkedList<Node> children) {
        if (index < 0) {
            throw new DOMException(1, "Index is negative");
        }
        if (children != null) {
            if (index >= children.size()) {
                throw new DOMException(1, "Index " + index + " is equal or greater than the number of rows: " + children.size());
            }
        } else {
            throw new DOMException(1, "Index " + index + " is equal or greater than the number of rows: 0");
        }
        HTMLElement elem = (HTMLElement)children.get(index);
        this.removeChild(elem);
    }

    public void deleteElement(int index, String localName, boolean recursive) {
        LinkedList<Node> children = this.getChildrenArray(localName, recursive);
        this.deleteElement(index, children);
    }

    public void methodCallNoParam(String methodName) {
        if (!this.delegate.isInternalMode()) {
            this.getDelegateHTMLElement().methodCallNoParam(methodName);
        }
    }

    public boolean getAttributeBoolean(String name) {
        return this.hasAttribute(name);
    }

    public void setAttributeBoolean(String name, boolean value) {
        HTMLElementImpl.setAttributeBoolean(this, name, value);
    }

    public static void setAttributeBoolean(Element elem, String name, boolean value) {
        if (value) {
            elem.setAttribute(name, name);
        } else {
            elem.removeAttribute(name);
        }
    }
}

