/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domimpl.html;

import org.itsnat.core.domutil.ItsNatTreeWalker;
import org.itsnat.impl.core.domimpl.DocumentImpl;
import org.itsnat.impl.core.domimpl.html.HTMLCollectionImpl;
import org.itsnat.impl.core.domimpl.html.NodeListByNameImpl;
import org.itsnat.impl.core.domutil.DOMUtilHTML;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLBodyElement;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLFrameSetElement;
import org.w3c.dom.html.HTMLHeadElement;
import org.w3c.dom.html.HTMLTitleElement;

public class HTMLDocumentImpl
extends DocumentImpl
implements HTMLDocument {
    protected HTMLCollection anchors;
    protected HTMLCollection applets;
    protected HTMLCollection forms;
    protected HTMLCollection images;
    protected HTMLCollection links;

    public HTMLDocumentImpl() {
    }

    public HTMLDocumentImpl(DocumentType dt, DOMImplementation impl) {
        super(dt, impl);
    }

    @Override
    public Element createElementInternal(String localName) {
        return this.createHTMLElement(null, localName);
    }

    protected Node newNode() {
        return new HTMLDocumentImpl(null, this.getImplementation());
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getCookie() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDomain() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getReferrer() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public HTMLHeadElement getHead() {
        return DOMUtilHTML.getHTMLHead(this);
    }

    public HTMLTitleElement getTitleElement() {
        Node title;
        HTMLHeadElement head = this.getHead();
        if (head == null) {
            return null;
        }
        for (title = head.getFirstChild(); title != null && !(title instanceof HTMLTitleElement); title = title.getNextSibling()) {
        }
        return (HTMLTitleElement)title;
    }

    @Override
    public String getTitle() {
        HTMLTitleElement title = this.getTitleElement();
        if (title == null) {
            return "";
        }
        return title.getText();
    }

    @Override
    public String getURL() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCookie(String cookie) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTitle(String title) {
        HTMLTitleElement titleElem = this.getTitleElement();
        if (titleElem == null) {
            throw new DOMException(8, "<title> element is missing");
        }
        titleElem.setText(title);
    }

    @Override
    public void write(String text) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeln(String text) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public HTMLCollection getAnchors() {
        if (this.anchors == null) {
            this.anchors = new HTMLCollectionImpl(this.getDocumentElement(), 1);
        }
        return this.anchors;
    }

    @Override
    public HTMLCollection getApplets() {
        if (this.applets == null) {
            this.applets = new HTMLCollectionImpl(this.getDocumentElement(), 4);
        }
        return this.applets;
    }

    @Override
    public HTMLCollection getForms() {
        if (this.forms == null) {
            this.forms = new HTMLCollectionImpl(this.getDocumentElement(), 2);
        }
        return this.forms;
    }

    @Override
    public HTMLCollection getImages() {
        if (this.images == null) {
            this.images = new HTMLCollectionImpl(this.getDocumentElement(), 3);
        }
        return this.images;
    }

    @Override
    public HTMLCollection getLinks() {
        if (this.links == null) {
            this.links = new HTMLCollectionImpl(this.getDocumentElement(), 5);
        }
        return this.links;
    }

    @Override
    public HTMLElement getBody() {
        Node body;
        Element html = this.getDocumentElement();
        if (html == null) {
            return null;
        }
        for (body = html.getFirstChild(); body != null && !(body instanceof HTMLBodyElement) && !(body instanceof HTMLFrameSetElement); body = body.getNextSibling()) {
        }
        return (HTMLElement)body;
    }

    @Override
    public void setBody(HTMLElement body) {
        Element html = this.getDocumentElement();
        if (html == null) {
            throw new DOMException(8, "<html> element is not defined");
        }
        Element currBody = ItsNatTreeWalker.getLastChildElement(html);
        if (currBody instanceof HTMLBodyElement || currBody instanceof HTMLFrameSetElement) {
            currBody.getParentNode().replaceChild(body, currBody);
        } else {
            html.appendChild(body);
        }
    }

    @Override
    public NodeList getElementsByName(String elementName) {
        return new NodeListByNameImpl(this, elementName);
    }
}

