/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domimpl.html;

import org.itsnat.impl.core.domimpl.html.NodeListBaseImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLAppletElement;
import org.w3c.dom.html.HTMLAreaElement;
import org.w3c.dom.html.HTMLButtonElement;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLFieldSetElement;
import org.w3c.dom.html.HTMLFormElement;
import org.w3c.dom.html.HTMLImageElement;
import org.w3c.dom.html.HTMLInputElement;
import org.w3c.dom.html.HTMLLabelElement;
import org.w3c.dom.html.HTMLObjectElement;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLSelectElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;
import org.w3c.dom.html.HTMLTextAreaElement;

public class HTMLCollectionImpl
extends NodeListBaseImpl
implements HTMLCollection {
    public static final short ANCHOR = 1;
    public static final short FORM = 2;
    public static final short IMAGE = 3;
    public static final short APPLET = 4;
    public static final short LINK = 5;
    public static final short OPTION = 6;
    public static final short ROW = 7;
    public static final short FORM_ELEMENT = 8;
    public static final short AREA = -1;
    public static final short TBODY = -2;
    public static final short CELL = -3;
    protected short type;

    public HTMLCollectionImpl(Element topElement, short type) {
        super(topElement);
        this.type = type;
    }

    @Override
    public boolean isRecursive() {
        return this.type > 0;
    }

    @Override
    public boolean machElement(Element elem, String name) {
        boolean match = false;
        switch (this.type) {
            case 1: {
                match = elem instanceof HTMLAnchorElement && elem.getAttribute("name").length() > 0;
                break;
            }
            case 2: {
                match = elem instanceof HTMLFormElement;
                break;
            }
            case 3: {
                match = elem instanceof HTMLImageElement;
                break;
            }
            case 4: {
                match = elem instanceof HTMLAppletElement || elem instanceof HTMLObjectElement && ("application/java".equals(elem.getAttribute("codetype")) || elem.getAttribute("classid").startsWith("java:"));
                break;
            }
            case 8: {
                match = elem instanceof HTMLButtonElement || elem instanceof HTMLFieldSetElement || elem instanceof HTMLInputElement || elem instanceof HTMLLabelElement || elem instanceof HTMLSelectElement || elem instanceof HTMLTextAreaElement;
                break;
            }
            case 5: {
                match = (elem instanceof HTMLAnchorElement || elem instanceof HTMLAreaElement) && elem.getAttribute("href").length() > 0;
                break;
            }
            case -1: {
                match = elem instanceof HTMLAreaElement;
                break;
            }
            case 6: {
                match = elem instanceof HTMLOptionElement;
                break;
            }
            case 7: {
                match = elem instanceof HTMLTableRowElement;
                break;
            }
            case -2: {
                match = elem instanceof HTMLTableSectionElement && elem.getLocalName().equals("tbody");
                break;
            }
            case -3: {
                match = elem instanceof HTMLTableCellElement;
            }
        }
        if (match && name != null) {
            if (elem instanceof HTMLAnchorElement && name.equals(elem.getAttribute("name"))) {
                return true;
            }
            return name.equals(elem.getAttribute("id"));
        }
        return match;
    }

    @Override
    public int getLength() {
        return this.getLength(null);
    }

    @Override
    public Node item(int index) {
        return this.item(index, null);
    }

    @Override
    public Node namedItem(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        return this.item(0, name);
    }
}

