/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domimpl.deleg;

import org.itsnat.core.ItsNatException;
import org.itsnat.core.event.ItsNatEvent;
import org.itsnat.impl.core.ItsNatUserDataImpl;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domimpl.ItsNatNodeInternal;
import org.itsnat.impl.core.domimpl.deleg.DelegateDocumentImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;

public abstract class DelegateNodeImpl
extends ItsNatUserDataImpl {
    protected ItsNatNodeInternal node;
    protected Boolean internalMode;

    public DelegateNodeImpl(ItsNatNodeInternal node) {
        super(false);
        this.node = node;
    }

    public abstract ItsNatDocumentImpl getItsNatDocument();

    public abstract DelegateDocumentImpl getDelegateDocument();

    public abstract boolean isInternalMode();

    public void setInternalMode(boolean mode) {
        if (mode) {
            this.internalMode = Boolean.TRUE;
        } else {
            ItsNatDocumentImpl itsNatDoc = this.getItsNatDocument();
            if (itsNatDoc == null) {
                throw new DOMException(11, "Non-local event mode cannot be set in a non-remote DOM document");
            }
            this.internalMode = Boolean.FALSE;
        }
    }

    public boolean isDispatchEventInternal(Event evt) {
        return !(evt instanceof ItsNatEvent);
    }

    public boolean dispatchEventRemote(Event evt) throws EventException {
        return this.getItsNatDocument().dispatchEvent(this.node, evt);
    }

    public boolean isAddRemoveEventListenerInternal() {
        return this.isInternalMode();
    }

    public void addEventListenerRemote(String type, EventListener listener, boolean useCapture) {
        ItsNatDocumentImpl itsNatDoc = this.getItsNatDocument();
        itsNatDoc.addEventListener(this.node, type, listener, useCapture);
    }

    public void removeEventListenerRemote(String type, EventListener listener, boolean useCapture) {
        ItsNatDocumentImpl itsNatDoc = this.getItsNatDocument();
        itsNatDoc.removeEventListener(this.node, type, listener, useCapture);
    }

    public void checkHasSenseDisconnectedFromClient() {
        ItsNatDocumentImpl itsNatDoc = this.getItsNatDocument();
        if (itsNatDoc == null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
    }

    public void checkHasSenseDisconnectedChildNodesFromClient() {
        this.checkHasSenseDisconnectedFromClient();
    }

    public static boolean isNodeBoundToDocumentTree(Node node) {
        if (node == null) {
            return false;
        }
        Node parent = node;
        while ((parent = (node = parent).getParentNode()) != null) {
        }
        return node.getNodeType() == 9;
    }

    public abstract boolean isMutationEventInternal();

    public abstract void setMutationEventInternal(boolean var1);

    public abstract boolean isDisconnectedFromClient();

    public abstract boolean isDisconnectedChildNodesFromClient();

    public abstract void setDisconnectedChildNodesFromClient(boolean var1);
}

