/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.domimpl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.batik.dom.AbstractAttr;
import org.itsnat.impl.core.domimpl.DocumentImpl;
import org.itsnat.impl.core.listener.EventListenerSerializableInternal;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;

public class ElementsByIdImpl
implements EventListenerSerializableInternal {
    protected DocumentImpl doc;
    protected Map<String, Object> elementsById;

    public ElementsByIdImpl(DocumentImpl doc) {
        this.doc = doc;
        doc.addEventListenerInternal("DOMNodeInserted", this, false);
        doc.addEventListenerInternal("DOMNodeRemoved", this, false);
    }

    public Node getRoot(Node n) {
        Node r = n;
        while (n != null) {
            r = n;
            n = n.getParentNode();
        }
        return r;
    }

    public boolean isInsideDoc(Node node) {
        return this.getRoot(node) == this.doc;
    }

    public Element getElementById(String id) {
        return this.getChildElementById(this.doc.getDocumentElement(), id);
    }

    public Element getChildElementById(Node requestor, String id) {
        boolean all;
        if (id == null || id.length() == 0) {
            return null;
        }
        if (this.elementsById == null) {
            return null;
        }
        Object o = this.elementsById.get(id);
        if (o == null) {
            return null;
        }
        Node root = this.getRoot(requestor);
        boolean bl = all = root == this.doc;
        if (o instanceof Element) {
            Element e = (Element)o;
            if (all || this.getRoot(e) == root) {
                return e;
            }
        } else {
            List l = (List)o;
            for (Element e : l) {
                if (!all && this.getRoot(e) != root) continue;
                return e;
            }
        }
        return null;
    }

    public void removeIdEntry(Element e, String id) {
        this.removeIdEntry(e, id, true);
    }

    public void removeIdEntry(Element e, String id, boolean checkInDoc) {
        if (id == null) {
            return;
        }
        if (this.elementsById == null) {
            return;
        }
        if (checkInDoc && !this.isInsideDoc(e)) {
            return;
        }
        Object o = this.elementsById.get(id);
        if (o == null) {
            return;
        }
        if (o instanceof Element) {
            this.elementsById.remove(id);
        } else {
            List l = (List)o;
            Iterator li = l.iterator();
            while (li.hasNext()) {
                Element currElem = (Element)li.next();
                if (e != currElem) continue;
                li.remove();
                break;
            }
            if (l.isEmpty()) {
                this.elementsById.remove(id);
            }
        }
    }

    public void addIdEntry(Element e, String id) {
        this.addIdEntry(e, id, true);
    }

    public void addIdEntry(Element e, String id, boolean checkInDoc) {
        Object o;
        if (id == null) {
            return;
        }
        if (checkInDoc && !this.isInsideDoc(e)) {
            return;
        }
        if (this.elementsById == null) {
            this.elementsById = new HashMap<String, Object>();
        }
        if ((o = this.elementsById.get(id)) == null) {
            this.elementsById.put(id, e);
        } else if (o instanceof Element) {
            Element currElem = (Element)o;
            ArrayList<Element> l = new ArrayList<Element>(4);
            l.add(currElem);
            l.add(e);
            this.elementsById.put(id, l);
        } else {
            List l = (List)o;
            l.add(e);
        }
    }

    public void updateIdEntry(Element e, String oldId, String newId) {
        this.updateIdEntry(e, oldId, newId, true);
    }

    public void updateIdEntry(Element e, String oldId, String newId, boolean checkInDoc) {
        if (oldId == newId || oldId != null && oldId.equals(newId)) {
            return;
        }
        if (checkInDoc && !this.isInsideDoc(e)) {
            return;
        }
        this.removeIdEntry(e, oldId, false);
        this.addIdEntry(e, newId, false);
    }

    @Override
    public void handleEvent(Event evt) {
        Node node = (Node)((Object)evt.getTarget());
        String type = evt.getType();
        if (type.equals("DOMNodeInserted")) {
            this.processTreeAddRemoveElementsWithId(node, true);
        } else {
            this.processTreeAddRemoveElementsWithId(node, false);
        }
    }

    protected void processTreeAddRemoveElementsWithId(Node node, boolean add) {
        if (node.getNodeType() != 1) {
            return;
        }
        Element elem = (Element)node;
        if (elem.hasAttributes()) {
            NamedNodeMap attributes = elem.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                AbstractAttr attr = (AbstractAttr)attributes.item(i);
                if (!attr.isId()) continue;
                if (add) {
                    this.addIdEntry(elem, attr.getValue(), false);
                    break;
                }
                this.removeIdEntry(elem, attr.getValue(), false);
                break;
            }
        }
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.processTreeAddRemoveElementsWithId(child, add);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.doc.addEventListenerInternal("DOMNodeInserted", this, false);
        this.doc.addEventListenerInternal("DOMNodeRemoved", this, false);
    }
}

