/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.doc.droid;

import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContext;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.event.ParamTransport;
import org.itsnat.impl.comp.mgr.ItsNatDocComponentManagerImpl;
import org.itsnat.impl.comp.mgr.droid.ItsNatStfulDroidDocComponentManagerImpl;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.domutil.DefaultElementGroupManagerImpl;
import org.itsnat.impl.core.domutil.ElementGroupManagerImpl;
import org.itsnat.impl.core.listener.droid.ItsNatDroidEventListenerWrapperImpl;
import org.itsnat.impl.core.mut.doc.DocMutationEventListenerImpl;
import org.itsnat.impl.core.mut.doc.droid.DocMutationEventListenerStfulDroidImpl;
import org.itsnat.impl.core.registry.droid.ItsNatDroidEventListenerRegistryImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.itsnat.impl.core.template.ItsNatDocumentTemplateVersionImpl;
import org.itsnat.impl.core.template.droid.ItsNatStfulDroidDocumentTemplateVersionImpl;
import org.itsnat.impl.core.template.droid.ScriptCode;
import org.itsnat.impl.core.template.droid.ScriptCodeInline;
import org.itsnat.impl.core.template.droid.ScriptWithSrc;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class ItsNatStfulDroidDocumentImpl
extends ItsNatStfulDocumentImpl {
    public static final boolean PRELOAD_SCRIPTS = false;
    protected ItsNatDroidEventListenerRegistryImpl droidEvtListenerRegistry;
    protected List<ScriptCode> scriptCodeList = new LinkedList<ScriptCode>();

    public ItsNatStfulDroidDocumentImpl(Document doc, ItsNatDocumentTemplateVersionImpl docTemplate, Browser browser, String requestURL, ItsNatSessionImpl ownerSession, boolean stateless) {
        super(doc, docTemplate, browser, requestURL, ownerSession, stateless);
        this.extractScriptElements();
    }

    public ItsNatStfulDroidDocumentTemplateVersionImpl getItsNatStfulDroidDocumentTemplateVersion() {
        return (ItsNatStfulDroidDocumentTemplateVersionImpl)this.docTemplateVersion;
    }

    @Override
    public Element getVisualRootElement() {
        return this.getDocument().getDocumentElement();
    }

    @Override
    public boolean isNewNodeDirectChildOfContentRoot(Node newNode) {
        Node parentNode = newNode.getParentNode();
        if (parentNode == null) {
            return false;
        }
        Document doc = this.getDocument();
        return parentNode.getParentNode() == doc.getDocumentElement();
    }

    @Override
    public DocMutationEventListenerImpl createInternalMutationEventListener() {
        return new DocMutationEventListenerStfulDroidImpl(this);
    }

    @Override
    public ElementGroupManagerImpl createElementGroupManager() {
        return new DefaultElementGroupManagerImpl(this);
    }

    @Override
    public ItsNatDocComponentManagerImpl createItsNatComponentManager() {
        return new ItsNatStfulDroidDocComponentManagerImpl(this);
    }

    @Override
    public int removeAllPlatformEventListeners(EventTarget target, boolean updateClient) {
        if (!this.hasDroidEventListeners()) {
            return 0;
        }
        return this.getDroidEventListenerRegistry().removeAllItsNatDroidEventListeners(target, updateClient);
    }

    public ItsNatDroidEventListenerWrapperImpl getDroidEventListenerById(String listenerId) {
        if (!this.hasDroidEventListeners()) {
            return null;
        }
        return this.getDroidEventListenerRegistry().getItsNatDroidEventListenerById(listenerId);
    }

    @Override
    public void addPlatformEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        this.addDroidEventListener(nodeTarget, type, listener, useCapture, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
    }

    public void addDroidEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        this.getDroidEventListenerRegistry().addItsNatDroidEventListener(nodeTarget, type, listener, useCapture, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
    }

    @Override
    public void removePlatformEventListener(EventTarget target, String type, EventListener listener, boolean useCapture, boolean updateClient) {
        this.removeDroidEventListener(target, type, listener, useCapture, updateClient);
    }

    public void removeDroidEventListener(EventTarget target, String type, EventListener listener, boolean useCapture, boolean updateClient) {
        this.getDroidEventListenerRegistry().removeItsNatDroidEventListener(target, type, listener, useCapture, updateClient);
    }

    @Override
    public void addMutationEventListener(EventTarget target, EventListener listener, boolean useCapture, int commMode, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        throw new ItsNatException("Mutation events are not supported in Droid ItsNat documents");
    }

    @Override
    public void addMutationEventListener(EventTarget nodeTarget, EventListener mutationListener, boolean useCapture) {
        throw new ItsNatException("Mutation events are not supported in Droid ItsNat documents");
    }

    @Override
    public void removeMutationEventListener(EventTarget target, EventListener listener, boolean useCapture) {
        throw new ItsNatException("Mutation events are not supported in Droid ItsNat documents");
    }

    public boolean hasDroidEventListeners() {
        if (this.droidEvtListenerRegistry == null) {
            return false;
        }
        return !this.droidEvtListenerRegistry.isEmpty();
    }

    public ItsNatDroidEventListenerRegistryImpl getDroidEventListenerRegistry() {
        if (this.droidEvtListenerRegistry == null) {
            this.droidEvtListenerRegistry = new ItsNatDroidEventListenerRegistryImpl(this, null);
        }
        return this.droidEvtListenerRegistry;
    }

    @Override
    public void renderPlatformEventListeners(ClientDocumentAttachedClientImpl clientDoc) {
        if (this.hasDroidEventListeners()) {
            this.getDroidEventListenerRegistry().renderItsNatNormalEventListeners(clientDoc);
        }
    }

    protected void extractScriptElements() {
        NodeList scriptElemList = this.doc.getElementsByTagName("script");
        int len = scriptElemList.getLength();
        if (len > 0) {
            ServletContext servContext = this.getItsNatDocumentTemplateImpl().getItsNatServletImpl().getServlet().getServletConfig().getServletContext();
            for (int i = 0; i < len; ++i) {
                Element scriptElem = (Element)scriptElemList.item(i);
                this.addScript(scriptElem, servContext);
            }
            while (scriptElemList.getLength() > 0) {
                Element scriptElem = (Element)scriptElemList.item(0);
                scriptElem.getParentNode().removeChild(scriptElem);
            }
        }
    }

    public List<ScriptCode> getScriptCodeList() {
        return this.scriptCodeList;
    }

    public void addScript(Element scriptElem) {
        ServletContext servContext = this.getItsNatDocumentTemplateImpl().getItsNatServletImpl().getServlet().getServletConfig().getServletContext();
        this.addScript(scriptElem, servContext);
    }

    private void addScript(Element scriptElem, ServletContext servContext) {
        ScriptCode scriptCodeItem = null;
        String src = scriptElem.getAttribute("src");
        if (!"".equals(src)) {
            scriptCodeItem = new ScriptWithSrc(src);
        } else {
            String code = DOMUtilInternal.getTextContent(scriptElem, true);
            scriptCodeItem = new ScriptCodeInline(code);
        }
        this.scriptCodeList.add(scriptCodeItem);
    }
}

