/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.doc;

import java.io.Serializable;
import java.util.Date;
import org.itsnat.core.ClientDocument;
import org.itsnat.core.ItsNatDocument;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatTimer;
import org.itsnat.core.event.ItsNatTimerHandle;
import org.itsnat.core.event.ParamTransport;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.listener.dom.domext.ItsNatTimerEventListenerWrapperImpl;
import org.itsnat.impl.core.util.MapUniqueId;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class ItsNatTimerImpl
implements ItsNatTimer,
Serializable {
    protected MapUniqueId<ItsNatTimerEventListenerWrapperImpl> listeners;
    protected ClientDocumentStfulImpl clientDoc;
    protected boolean canceled = false;

    public ItsNatTimerImpl(ClientDocumentStfulImpl clientDoc) {
        this.clientDoc = clientDoc;
    }

    @Override
    public ItsNatDocument getItsNatDocument() {
        return this.getItsNatStfulDocument();
    }

    public ItsNatStfulDocumentImpl getItsNatStfulDocument() {
        return this.clientDoc.getItsNatStfulDocument();
    }

    @Override
    public ClientDocument getClientDocument() {
        return this.clientDoc;
    }

    public ClientDocumentStfulImpl getClientDocumentStful() {
        return this.clientDoc;
    }

    public MapUniqueId<ItsNatTimerEventListenerWrapperImpl> getListeners() {
        if (this.listeners == null) {
            this.listeners = new MapUniqueId(this.clientDoc.getUniqueIdGenerator());
        }
        return this.listeners;
    }

    @Override
    public void cancel() {
        if (this.canceled) {
            return;
        }
        MapUniqueId<ItsNatTimerEventListenerWrapperImpl> listeners = this.getListeners();
        if (!listeners.isEmpty()) {
            ItsNatTimerEventListenerWrapperImpl[] listenerArray = listeners.values().toArray(new ItsNatTimerEventListenerWrapperImpl[listeners.size()]);
            for (int i = 0; i < listenerArray.length; ++i) {
                ItsNatTimerEventListenerWrapperImpl listener = listenerArray[i];
                listener.cancel();
            }
            listeners.clear();
        }
        this.canceled = true;
    }

    public ItsNatTimerEventListenerWrapperImpl getTimerEventListenerWrapper(String id) {
        MapUniqueId<ItsNatTimerEventListenerWrapperImpl> listeners = this.getListeners();
        return listeners.get(id);
    }

    public void removeListener(ItsNatTimerEventListenerWrapperImpl listener) {
        this.clientDoc.getItsNatTimerEventListenerRegistry().removeItsNatTimerEventListener(listener, true);
    }

    private ItsNatTimerHandle scheduleGeneric(EventTarget target, EventListener listener, long time, long period, boolean fixedRate, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        if (this.canceled) {
            throw new ItsNatException("This timer is cancelled", (Object)this);
        }
        return this.clientDoc.getItsNatTimerEventListenerRegistry().addItsNatTimerEventListener(target, listener, time, period, fixedRate, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc, this);
    }

    public void addListenerLocal(ItsNatTimerEventListenerWrapperImpl listenerWrapper) {
        MapUniqueId<ItsNatTimerEventListenerWrapperImpl> listeners = this.getListeners();
        listeners.put(listenerWrapper);
    }

    public void removeListenerLocal(ItsNatTimerEventListenerWrapperImpl listener) {
        MapUniqueId<ItsNatTimerEventListenerWrapperImpl> listeners = this.getListeners();
        listeners.remove(listener);
    }

    @Override
    public ItsNatTimerHandle schedule(EventTarget target, EventListener task, Date time) {
        int commMode = this.clientDoc.getCommMode();
        long eventTimeout = this.clientDoc.getEventTimeout();
        return this.schedule(target, task, time, commMode, null, null, eventTimeout);
    }

    @Override
    public ItsNatTimerHandle schedule(EventTarget target, EventListener task, Date time, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout) {
        return this.scheduleGeneric(target, task, time.getTime(), 0L, false, commMode, extraParams, preSendCode, eventTimeout, null);
    }

    @Override
    public ItsNatTimerHandle schedule(EventTarget target, EventListener task, Date firstTime, long period) {
        int commMode = this.clientDoc.getCommMode();
        long eventTimeout = this.clientDoc.getEventTimeout();
        return this.schedule(target, task, firstTime, period, commMode, null, null, eventTimeout);
    }

    @Override
    public ItsNatTimerHandle schedule(EventTarget target, EventListener task, Date firstTime, long period, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout) {
        return this.scheduleGeneric(target, task, firstTime.getTime(), period, false, commMode, extraParams, preSendCode, eventTimeout, null);
    }

    @Override
    public ItsNatTimerHandle schedule(EventTarget target, EventListener task, long delay) {
        int commMode = this.clientDoc.getCommMode();
        long eventTimeout = this.clientDoc.getEventTimeout();
        return this.schedule(target, task, delay, commMode, null, null, eventTimeout);
    }

    @Override
    public ItsNatTimerHandle schedule(EventTarget target, EventListener task, long delay, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay");
        }
        return this.scheduleGeneric(target, task, System.currentTimeMillis() + delay, 0L, false, commMode, extraParams, preSendCode, eventTimeout, null);
    }

    @Override
    public ItsNatTimerHandle schedule(EventTarget target, EventListener task, long delay, long period) {
        int commMode = this.clientDoc.getCommMode();
        long eventTimeout = this.clientDoc.getEventTimeout();
        return this.schedule(target, task, delay, period, commMode, null, null, eventTimeout);
    }

    @Override
    public ItsNatTimerHandle schedule(EventTarget target, EventListener task, long delay, long period, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay");
        }
        return this.scheduleGeneric(target, task, System.currentTimeMillis() + delay, period, false, commMode, extraParams, preSendCode, eventTimeout, null);
    }

    @Override
    public ItsNatTimerHandle scheduleAtFixedRate(EventTarget target, EventListener task, Date firstTime, long period) {
        int commMode = this.clientDoc.getCommMode();
        long eventTimeout = this.clientDoc.getEventTimeout();
        return this.scheduleAtFixedRate(target, task, firstTime, period, commMode, null, null, eventTimeout);
    }

    @Override
    public ItsNatTimerHandle scheduleAtFixedRate(EventTarget target, EventListener task, Date firstTime, long period, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout) {
        return this.scheduleGeneric(target, task, firstTime.getTime(), period, true, commMode, extraParams, preSendCode, eventTimeout, null);
    }

    @Override
    public ItsNatTimerHandle scheduleAtFixedRate(EventTarget target, EventListener task, long delay, long period) {
        int commMode = this.clientDoc.getCommMode();
        long eventTimeout = this.clientDoc.getEventTimeout();
        return this.scheduleAtFixedRate(target, task, delay, period, commMode, null, null, eventTimeout);
    }

    @Override
    public ItsNatTimerHandle scheduleAtFixedRate(EventTarget target, EventListener task, long delay, long period, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay");
        }
        return this.scheduleGeneric(target, task, System.currentTimeMillis() + delay, period, true, commMode, extraParams, preSendCode, eventTimeout, null);
    }
}

