/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.doc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatServletRequest;
import org.itsnat.core.ItsNatServletResponse;
import org.itsnat.core.event.CodeToSendListener;
import org.itsnat.core.event.ItsNatAttachedClientEventListener;
import org.itsnat.core.event.ItsNatServletRequestListener;
import org.itsnat.core.event.ParamTransport;
import org.itsnat.core.script.ScriptUtil;
import org.itsnat.impl.comp.mgr.ItsNatStfulDocComponentManagerImpl;
import org.itsnat.impl.core.CommModeImpl;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.clientdoc.ClientDocStfulTask;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulOwnerImpl;
import org.itsnat.impl.core.doc.BoundElementDocContainerImpl;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domimpl.ElementDocContainer;
import org.itsnat.impl.core.event.CodeToSendEventImpl;
import org.itsnat.impl.core.event.CodeToSendListenersImpl;
import org.itsnat.impl.core.event.server.ServerItsNatNormalEventImpl;
import org.itsnat.impl.core.listener.dom.domext.ItsNatDOMExtEventListenerWrapperImpl;
import org.itsnat.impl.core.listener.dom.domext.ItsNatUserEventListenerWrapperImpl;
import org.itsnat.impl.core.mut.doc.DocMutationEventListenerStfulImpl;
import org.itsnat.impl.core.registry.dom.domext.ItsNatUserEventListenerRegistryImpl;
import org.itsnat.impl.core.scriptren.shared.ScriptUtilImpl;
import org.itsnat.impl.core.servlet.ItsNatServletConfigImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.itsnat.impl.core.template.ItsNatDocumentTemplateVersionImpl;
import org.itsnat.impl.core.template.ItsNatStfulDocumentTemplateVersionImpl;
import org.itsnat.impl.core.util.MapUniqueId;
import org.itsnat.impl.core.util.WeakSetImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class ItsNatStfulDocumentImpl
extends ItsNatDocumentImpl {
    protected ScriptUtilImpl scriptUtil;
    protected ItsNatUserEventListenerRegistryImpl userListenerRegistry;
    protected boolean enabledSendCode = true;
    protected WeakSetImpl<ClientDocumentAttachedClientImpl> clientDocAttachedSet;
    protected int commMode;
    protected long eventTimeout;
    protected CodeToSendListenersImpl codeToSendListeners;
    protected LinkedList<EventListener> globalNormalEventListeners;
    protected LinkedList<ItsNatAttachedClientEventListener> attachedClientListeners;
    protected LinkedList<ItsNatServletRequestListener> referrerRequestListeners;
    protected transient ThreadLocal<ClientDocumentStfulImpl> evtDispThreadLocal = new ThreadLocal();
    protected long evtDispMaxWait;
    protected int maxOpenClients;
    protected MapUniqueId<BoundElementDocContainerImpl> boundElemDocContainers;
    protected Random random;

    public ItsNatStfulDocumentImpl(Document doc, ItsNatDocumentTemplateVersionImpl docTemplate, Browser browser, String requestURL, ItsNatSessionImpl ownerSession, boolean stateless) {
        super(doc, docTemplate, browser, requestURL, ownerSession, stateless);
        this.commMode = docTemplate.getCommMode();
        this.eventTimeout = docTemplate.getEventTimeout();
        this.evtDispMaxWait = docTemplate.getEventDispatcherMaxWait();
        this.maxOpenClients = docTemplate.getMaxOpenClientsByDocument();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.evtDispThreadLocal = new ThreadLocal();
        in.defaultReadObject();
    }

    public ItsNatStfulDocComponentManagerImpl getItsNatStfulComponentManager() {
        return (ItsNatStfulDocComponentManagerImpl)this.componentMgr;
    }

    public DocMutationEventListenerStfulImpl getDocMutationListenerEventStful() {
        return (DocMutationEventListenerStfulImpl)this.mutationListener;
    }

    public boolean canRenderAndSendMutationCode() {
        boolean loading = this.isLoading();
        return !loading || loading && !this.isFastLoadMode();
    }

    public ItsNatStfulDocumentTemplateVersionImpl getItsNatStfulDocumentTemplateVersion() {
        return (ItsNatStfulDocumentTemplateVersionImpl)this.docTemplateVersion;
    }

    @Override
    public ClientDocumentImpl createClientDocumentOwner(Browser browser, ItsNatSessionImpl ownerSession) {
        return new ClientDocumentStfulOwnerImpl(this, browser, ownerSession);
    }

    public ClientDocumentStfulOwnerImpl getClientDocumentStfulOwner() {
        return (ClientDocumentStfulOwnerImpl)this.clientDocOwner;
    }

    public ClientDocumentStfulImpl getRequestingClientDocumentStful() {
        ItsNatServletRequestImpl request = this.getCurrentItsNatServletRequest();
        if (request != null) {
            return (ClientDocumentStfulImpl)request.getClientDocumentImpl();
        }
        return this.getClientDocumentStfulOwner();
    }

    @Override
    public ScriptUtil getScriptUtil() {
        if (this.scriptUtil == null) {
            this.scriptUtil = ScriptUtilImpl.createScriptUtilFromDoc(this);
        }
        return this.scriptUtil;
    }

    @Override
    public int getCommMode() {
        return this.commMode;
    }

    @Override
    public void setCommMode(int commMode) {
        CommModeImpl.checkMode(commMode);
        this.commMode = commMode;
    }

    @Override
    public long getEventTimeout() {
        return this.eventTimeout;
    }

    @Override
    public void setEventTimeout(long timeout) {
        this.eventTimeout = timeout;
    }

    @Override
    public void addEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture) {
        int commMode = this.getCommMode();
        long eventTimeout = this.getEventTimeout();
        this.addEventListener(nodeTarget, type, listener, useCapture, commMode, null, null, eventTimeout);
    }

    @Override
    public void addEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, int commMode) {
        long eventTimeout = this.getEventTimeout();
        this.addEventListener(nodeTarget, type, listener, useCapture, commMode, null, null, eventTimeout);
    }

    @Override
    public void addEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, ParamTransport extraParam) {
        ParamTransport[] extraParams = new ParamTransport[]{extraParam};
        this.addEventListener(nodeTarget, type, listener, useCapture, extraParams);
    }

    @Override
    public void addEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, ParamTransport[] extraParams) {
        int commMode = this.getCommMode();
        long eventTimeout = this.getEventTimeout();
        this.addEventListener(nodeTarget, type, listener, useCapture, commMode, extraParams, null, eventTimeout);
    }

    @Override
    public void addEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, String preSendCode) {
        int commMode = this.getCommMode();
        long eventTimeout = this.getEventTimeout();
        this.addEventListener(nodeTarget, type, listener, useCapture, commMode, null, preSendCode, eventTimeout);
    }

    @Override
    public void addEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout) {
        this.addEventListener(nodeTarget, type, listener, useCapture, commMode, extraParams, preSendCode, eventTimeout, null);
    }

    public void addEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        if (ItsNatDOMExtEventListenerWrapperImpl.isExtensionType(type)) {
            this.addDOMExtEventListener(nodeTarget, type, listener, useCapture, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
        } else {
            this.addPlatformEventListener(nodeTarget, type, listener, useCapture, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
        }
    }

    public abstract void addPlatformEventListener(EventTarget var1, String var2, EventListener var3, boolean var4, int var5, ParamTransport[] var6, String var7, long var8, String var10);

    public void addDOMExtEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        if (useCapture) {
            throw new ItsNatException("Capturing is not allowed for this type:" + type, (Object)this);
        }
        if (!ItsNatUserEventListenerWrapperImpl.isUserType(type)) {
            throw new ItsNatException("This method is not allowed to register this event listener type:" + type, (Object)this);
        }
        String name = ItsNatUserEventListenerWrapperImpl.getNameFromType(type, false);
        this.addUserEventListener(nodeTarget, name, listener, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
    }

    @Override
    public void addMutationEventListener(EventTarget target, EventListener listener, boolean useCapture, int commMode, String preSendCode, long eventTimeout) {
        this.addMutationEventListener(target, listener, useCapture, commMode, preSendCode, eventTimeout, null);
    }

    public abstract void addMutationEventListener(EventTarget var1, EventListener var2, boolean var3, int var4, String var5, long var6, String var8);

    @Override
    public void removeEventListener(EventTarget target, String type, EventListener listener, boolean useCapture) {
        this.removeEventListener(target, type, listener, useCapture, true);
    }

    @Override
    public void removeEventListener(EventTarget target, String type, EventListener listener, boolean useCapture, boolean updateClient) {
        if (ItsNatDOMExtEventListenerWrapperImpl.isExtensionType(type)) {
            this.removeDOMExtEventListener(target, type, listener, useCapture, updateClient);
        } else {
            this.removePlatformEventListener(target, type, listener, useCapture, updateClient);
        }
    }

    public abstract void removePlatformEventListener(EventTarget var1, String var2, EventListener var3, boolean var4, boolean var5);

    public abstract int removeAllPlatformEventListeners(EventTarget var1, boolean var2);

    public void removeDOMExtEventListener(EventTarget target, String type, EventListener listener, boolean useCapture, boolean updateClient) {
        if (useCapture) {
            return;
        }
        if (!ItsNatUserEventListenerWrapperImpl.isUserType(type)) {
            throw new ItsNatException("This method is not allowed to unregister this event listener type:" + type, (Object)this);
        }
        String name = ItsNatUserEventListenerWrapperImpl.getNameFromType(type, false);
        this.removeUserEventListener(target, name, listener, updateClient);
    }

    public boolean hasUserEventListeners() {
        if (this.userListenerRegistry == null) {
            return false;
        }
        return !this.userListenerRegistry.isEmpty();
    }

    public ItsNatUserEventListenerRegistryImpl getUserEventListenerRegistry() {
        if (this.userListenerRegistry == null) {
            this.userListenerRegistry = new ItsNatUserEventListenerRegistryImpl(this, null);
        }
        return this.userListenerRegistry;
    }

    @Override
    public void addUserEventListener(EventTarget target, String name, EventListener listener, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout) {
        this.addUserEventListener(target, name, listener, commMode, extraParams, preSendCode, eventTimeout, null);
    }

    @Override
    public void addUserEventListener(EventTarget target, String name, EventListener listener) {
        this.addUserEventListener(target, name, listener, this.getCommMode(), null, null, this.getEventTimeout(), null);
    }

    public void addUserEventListener(EventTarget target, String name, EventListener listener, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        this.getUserEventListenerRegistry().addItsNatUserEventListener(target, name, listener, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
    }

    public ItsNatUserEventListenerWrapperImpl getUserEventListenerById(String listenerId) {
        if (!this.hasUserEventListeners()) {
            return null;
        }
        return this.getUserEventListenerRegistry().getItsNatUserEventListenerById(listenerId);
    }

    @Override
    public void removeUserEventListener(EventTarget target, String name, EventListener listener) {
        this.removeUserEventListener(target, name, listener, true);
    }

    public void removeUserEventListener(EventTarget target, String name, EventListener listener, boolean updateClient) {
        this.getUserEventListenerRegistry().removeItsNatUserEventListener(target, name, listener, updateClient);
    }

    public int removeAllUserEventListeners(EventTarget target, boolean updateClient) {
        if (!this.hasUserEventListeners()) {
            return 0;
        }
        return this.getUserEventListenerRegistry().removeAllItsNatUserEventListeners(target, updateClient);
    }

    @Override
    public boolean isSendCodeEnabled() {
        return this.enabledSendCode;
    }

    @Override
    public void disableSendCode() {
        this.enabledSendCode = false;
    }

    @Override
    public void enableSendCode() {
        this.enabledSendCode = true;
    }

    public boolean hasClientDocumentAttachedClient() {
        if (this.clientDocAttachedSet == null) {
            return false;
        }
        return !this.clientDocAttachedSet.isEmpty();
    }

    public int getClientDocumentAttachedCount() {
        if (this.clientDocAttachedSet == null) {
            return 0;
        }
        return this.clientDocAttachedSet.size();
    }

    public WeakSetImpl<ClientDocumentAttachedClientImpl> getClientDocumentAttachedClientSet() {
        if (this.clientDocAttachedSet == null) {
            this.clientDocAttachedSet = new WeakSetImpl();
        }
        return this.clientDocAttachedSet;
    }

    public ClientDocumentAttachedClientImpl[] getClientDocumentAttachedClientArray() {
        if (!this.hasClientDocumentAttachedClient()) {
            return null;
        }
        WeakSetImpl<ClientDocumentAttachedClientImpl> attachedClients = this.getClientDocumentAttachedClientSet();
        return attachedClients.toArray(new ClientDocumentAttachedClientImpl[attachedClients.size()]);
    }

    public void addClientDocumentAttachedClient(ClientDocumentAttachedClientImpl clientDoc) {
        this.getClientDocumentAttachedClientSet().add(clientDoc);
        if (clientDoc.canReceiveSOMENormalEvents()) {
            this.renderPlatformEventListeners(clientDoc);
            if (this.hasUserEventListeners()) {
                this.getUserEventListenerRegistry().renderItsNatNormalEventListeners(clientDoc);
            }
        }
        this.getItsNatStfulComponentManager().addClientDocumentAttachedClient(clientDoc);
    }

    public abstract void renderPlatformEventListeners(ClientDocumentAttachedClientImpl var1);

    public void removeClientDocumentAttachedClient(ClientDocumentAttachedClientImpl clientDoc) {
        clientDoc.setInvalid();
        this.getClientDocumentAttachedClientSet().remove(clientDoc);
        this.getItsNatStfulComponentManager().removeClientDocumentAttachedClient(clientDoc);
    }

    public boolean allClientDocumentWillReceiveCodeSent() {
        if (!this.isSendCodeEnabled()) {
            return false;
        }
        ClientDocumentStfulOwnerImpl owner = this.getClientDocumentStfulOwner();
        if (!owner.isSendCodeEnabled()) {
            return false;
        }
        if (this.hasClientDocumentAttachedClient()) {
            WeakSetImpl<ClientDocumentAttachedClientImpl> clientDocs = this.getClientDocumentAttachedClientSet();
            for (ClientDocumentAttachedClientImpl client : clientDocs) {
                if (client.isSendCodeEnabled()) continue;
                return false;
            }
        }
        return true;
    }

    public ClientDocumentStfulImpl[] getAllClientDocumentStfulsCopy() {
        return (ClientDocumentStfulImpl[])this.getAllClientDocumentsCopy();
    }

    @Override
    public ClientDocumentImpl[] getAllClientDocumentsCopy() {
        ClientDocumentStfulOwnerImpl ownerClient = this.getClientDocumentStfulOwner();
        if (!this.hasClientDocumentAttachedClient()) {
            return new ClientDocumentStfulImpl[]{ownerClient};
        }
        WeakSetImpl<ClientDocumentAttachedClientImpl> attachedClients = this.getClientDocumentAttachedClientSet();
        ClientDocumentImpl[] res = new ClientDocumentStfulImpl[1 + attachedClients.size()];
        res[0] = ownerClient;
        int i = 1;
        for (ClientDocumentAttachedClientImpl clientDoc : attachedClients) {
            res[i] = clientDoc;
            ++i;
        }
        return res;
    }

    public boolean executeTaskOnClients(ClientDocStfulTask clientTask, Object arg) {
        ClientDocumentStfulOwnerImpl owner = this.getClientDocumentStfulOwner();
        boolean cont = clientTask.doTask(owner, arg);
        if (!cont) {
            return false;
        }
        if (this.hasClientDocumentAttachedClient()) {
            WeakSetImpl<ClientDocumentAttachedClientImpl> attachedClient = this.getClientDocumentAttachedClientSet();
            for (ClientDocumentAttachedClientImpl clientDoc : attachedClient) {
                cont = clientTask.doTask(clientDoc, arg);
                if (cont) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void addCodeToSend(Object code) {
        ClientDocumentStfulImpl[] allClient;
        if (!this.isScriptingEnabled()) {
            return;
        }
        if (!this.isSendCodeEnabled()) {
            return;
        }
        CodeToSendEventImpl event = null;
        if (this.hasCodeToSendListeners() && (code = (event = this.getCodeToSendListeners().preProcessCodeToSend(code)).getCode()) == null) {
            return;
        }
        for (ClientDocumentStfulImpl clientDoc : allClient = this.getAllClientDocumentStfulsCopy()) {
            if (!clientDoc.isSendCodeEnabled()) continue;
            clientDoc.addCodeToSend(code);
        }
        if (event != null) {
            this.getCodeToSendListeners().postProcessCodeToSend(event);
        }
    }

    public boolean hasCodeToSendListeners() {
        if (this.codeToSendListeners == null) {
            return false;
        }
        return this.codeToSendListeners.hasCodeToSendListeners();
    }

    public CodeToSendListenersImpl getCodeToSendListeners() {
        if (this.codeToSendListeners == null) {
            this.codeToSendListeners = new CodeToSendListenersImpl(this);
        }
        return this.codeToSendListeners;
    }

    @Override
    public void addCodeToSendListener(CodeToSendListener listener) {
        this.getCodeToSendListeners().addCodeToSendListener(listener);
    }

    @Override
    public void removeCodeToSendListener(CodeToSendListener listener) {
        this.getCodeToSendListeners().removeCodeToSendListener(listener);
    }

    @Override
    protected void setInvalidInternal() {
        ClientDocumentStfulImpl[] allClient;
        super.setInvalidInternal();
        for (ClientDocumentStfulImpl clientDoc : allClient = this.getAllClientDocumentStfulsCopy()) {
            clientDoc.setInvalid();
        }
    }

    public boolean isNodeCacheEnabled() {
        if (!this.isScriptingEnabled()) {
            return false;
        }
        return this.getItsNatDocumentTemplateVersion().isNodeCacheEnabled();
    }

    public LinkedList<ItsNatAttachedClientEventListener> getItsNatAttachedClientEventListeners() {
        if (this.attachedClientListeners == null) {
            this.attachedClientListeners = new LinkedList();
        }
        return this.attachedClientListeners;
    }

    public void getItsNatAttachedClientEventListenerList(LinkedList<ItsNatAttachedClientEventListener> list) {
        if (this.attachedClientListeners == null) {
            return;
        }
        list.addAll(this.attachedClientListeners);
    }

    @Override
    public void addItsNatAttachedClientEventListener(ItsNatAttachedClientEventListener listener) {
        LinkedList<ItsNatAttachedClientEventListener> attachedEventListeners = this.getItsNatAttachedClientEventListeners();
        attachedEventListeners.add(listener);
    }

    @Override
    public void removeItsNatAttachedClientEventListener(ItsNatAttachedClientEventListener listener) {
        LinkedList<ItsNatAttachedClientEventListener> attachedEventListeners = this.getItsNatAttachedClientEventListeners();
        attachedEventListeners.remove(listener);
    }

    public boolean hasGlobalEventListenerListeners() {
        if (this.globalNormalEventListeners == null) {
            return false;
        }
        return !this.globalNormalEventListeners.isEmpty();
    }

    public LinkedList<EventListener> getGlobalEventListenerList() {
        if (this.globalNormalEventListeners == null) {
            this.globalNormalEventListeners = new LinkedList();
        }
        return this.globalNormalEventListeners;
    }

    public void getGlobalEventListenerList(LinkedList<EventListener> list) {
        if (this.globalNormalEventListeners == null) {
            return;
        }
        list.addAll(this.globalNormalEventListeners);
    }

    @Override
    public void addEventListener(EventListener listener) {
        LinkedList<EventListener> globalEventListeners = this.getGlobalEventListenerList();
        globalEventListeners.add(listener);
    }

    public void addEventListener(int index, EventListener listener) {
        LinkedList<EventListener> globalEventListeners = this.getGlobalEventListenerList();
        globalEventListeners.add(index, listener);
    }

    @Override
    public void removeEventListener(EventListener listener) {
        LinkedList<EventListener> globalEventListeners = this.getGlobalEventListenerList();
        globalEventListeners.remove(listener);
    }

    @Override
    public Event createEvent(String eventType) throws DOMException {
        return ServerItsNatNormalEventImpl.createServerNormalEvent(eventType, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockThread(long maxWait) {
        ItsNatStfulDocumentImpl itsNatStfulDocumentImpl = this;
        synchronized (itsNatStfulDocumentImpl) {
            try {
                this.wait(maxWait);
            }
            catch (InterruptedException ex) {
                throw new ItsNatException(ex, (Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockThreads() {
        ItsNatStfulDocumentImpl itsNatStfulDocumentImpl = this;
        synchronized (itsNatStfulDocumentImpl) {
            this.notifyAll();
        }
    }

    @Override
    public boolean dispatchEvent(EventTarget target, Event evt) throws EventException {
        ClientDocumentStfulImpl clientDoc = this.getEventDispatcherClientDocByThread();
        if (clientDoc != null) {
            return clientDoc.dispatchEvent(target, evt);
        }
        return this.dispatchEventLocally(target, evt);
    }

    @Override
    public boolean dispatchEventLocally(EventTarget target, Event evt) throws EventException {
        return ServerItsNatNormalEventImpl.dispatchEventLocally(target, evt);
    }

    @Override
    public long getEventDispatcherMaxWait() {
        return this.evtDispMaxWait;
    }

    @Override
    public void setEventDispatcherMaxWait(long wait) {
        this.evtDispMaxWait = wait;
    }

    @Override
    public int getMaxOpenClientsByDocument() {
        return this.maxOpenClients;
    }

    @Override
    public void setMaxOpenClientsByDocument(int value) {
        ItsNatServletConfigImpl.checkMaxOpenClientsByDocument(value);
        this.maxOpenClients = value;
        this.getClientDocumentStfulOwner().getItsNatSessionImpl().cleanExcessClientDocumentAttachedClients(this);
    }

    public ClientDocumentStfulImpl getEventDispatcherClientDocByThread() {
        return this.evtDispThreadLocal.get();
    }

    public void setEventDispatcherClientDocByThread(ClientDocumentStfulImpl clientDoc) {
        this.evtDispThreadLocal.set(clientDoc);
    }

    public LinkedList<ItsNatServletRequestListener> getReferrerItsNatServletRequestListenerList() {
        if (this.referrerRequestListeners == null) {
            this.referrerRequestListeners = new LinkedList();
        }
        return this.referrerRequestListeners;
    }

    public Iterator<ItsNatServletRequestListener> getReferrerItsNatServletRequestListenerIterator() {
        if (this.referrerRequestListeners == null) {
            return null;
        }
        if (this.referrerRequestListeners.isEmpty()) {
            return null;
        }
        return this.referrerRequestListeners.iterator();
    }

    @Override
    public void addReferrerItsNatServletRequestListener(ItsNatServletRequestListener listener) {
        if (!this.isReferrerEnabled()) {
            throw new ItsNatException("Referrer feature is not enabled", (Object)this);
        }
        LinkedList<ItsNatServletRequestListener> referrerRequestListeners = this.getReferrerItsNatServletRequestListenerList();
        referrerRequestListeners.add(listener);
    }

    @Override
    public void removeReferrerItsNatServletRequestListener(ItsNatServletRequestListener listener) {
        LinkedList<ItsNatServletRequestListener> referrerRequestListeners = this.getReferrerItsNatServletRequestListenerList();
        referrerRequestListeners.remove(listener);
    }

    public void dispatchReferrerRequestListeners(ItsNatServletRequest request, ItsNatServletResponse response) {
        Iterator<ItsNatServletRequestListener> iterator = this.getReferrerItsNatServletRequestListenerIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                ItsNatServletRequestListener listener = iterator.next();
                listener.processRequest(request, response);
            }
        }
    }

    public void normalEventReceived(ClientDocumentStfulImpl clientDocSource) {
        ClientDocumentStfulOwnerImpl clientDocOwner = this.getClientDocumentStfulOwner();
        if (clientDocOwner != clientDocSource) {
            clientDocOwner.normalEventReceivedInDocument();
        }
        if (this.hasClientDocumentAttachedClient()) {
            WeakSetImpl<ClientDocumentAttachedClientImpl> clientDocs = this.getClientDocumentAttachedClientSet();
            for (ClientDocumentAttachedClientImpl clientDocAttached : clientDocs) {
                if (clientDocAttached == clientDocSource) continue;
                clientDocAttached.normalEventReceivedInDocument();
            }
        }
    }

    public Random getRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random;
    }

    public boolean hasBoundElementDocContainers() {
        if (this.boundElemDocContainers == null) {
            return false;
        }
        return !this.boundElemDocContainers.isEmpty();
    }

    public MapUniqueId<BoundElementDocContainerImpl> getBoundElementDocContainerMap() {
        if (this.boundElemDocContainers == null) {
            this.boundElemDocContainers = new MapUniqueId(this.getUniqueIdGenerator());
        }
        return this.boundElemDocContainers;
    }

    public BoundElementDocContainerImpl getBoundElementDocContainer(String id, int random) {
        if (!this.hasBoundElementDocContainers()) {
            return null;
        }
        BoundElementDocContainerImpl bindInfo = this.getBoundElementDocContainerMap().get(id);
        if (bindInfo == null) {
            return null;
        }
        if (bindInfo.getRandomNumber() != random) {
            return null;
        }
        return bindInfo;
    }

    public BoundElementDocContainerImpl addBoundElementDocContainer(ElementDocContainer elem, String docName) {
        BoundElementDocContainerImpl bindInfo = new BoundElementDocContainerImpl(elem, docName, this);
        BoundElementDocContainerImpl res = this.getBoundElementDocContainerMap().put(bindInfo);
        if (res != null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        return bindInfo;
    }

    public boolean removeBoundElementDocContainer(BoundElementDocContainerImpl bindInfo) {
        if (!this.hasBoundElementDocContainers()) {
            return false;
        }
        BoundElementDocContainerImpl res = this.getBoundElementDocContainerMap().remove(bindInfo);
        if (res != bindInfo) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        return true;
    }

    @Override
    public boolean isDisconnectedChildNodesFromClient(Node node) {
        return this.getDocMutationListenerEventStful().isDisconnectedChildNodesFromClient(node);
    }

    @Override
    public Node disconnectChildNodesFromClient(Node node) {
        return this.getDocMutationListenerEventStful().disconnectChildNodesFromClient(node);
    }

    @Override
    public void reconnectChildNodesToClient(Node node) {
        this.getDocMutationListenerEventStful().reconnectChildNodesToClient(node);
    }

    public abstract Element getVisualRootElement();

    public abstract boolean isNewNodeDirectChildOfContentRoot(Node var1);
}

