/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.doc;

import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.browser.web.BrowserMSIEOld;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.ElementDocContainerWrapperImpl;
import org.itsnat.impl.core.domimpl.ElementDocContainer;
import org.w3c.dom.Attr;
import org.w3c.dom.html.HTMLObjectElement;
import org.w3c.dom.html.HTMLParamElement;

public class HTMLObjectElementWrapperImpl
extends ElementDocContainerWrapperImpl {
    public HTMLObjectElementWrapperImpl(HTMLObjectElement elem) {
        super((ElementDocContainer)((Object)elem));
    }

    public HTMLObjectElement getHTMLObjectElement() {
        return (HTMLObjectElement)((Object)this.elem);
    }

    @Override
    public String getURL() {
        if (this.isJavaApplet()) {
            HTMLParamElement srcParam = this.getHTMLParamElementWithSrc();
            if (srcParam == null) {
                return "";
            }
            return srcParam.getValue();
        }
        return this.getHTMLObjectElement().getData();
    }

    @Override
    public void setURL(String url) {
        if (this.isJavaApplet()) {
            HTMLParamElement srcParam = this.getHTMLParamElementWithSrc();
            if (srcParam == null) {
                throw new ItsNatException("INTERNAL ERROR");
            }
            srcParam.setValue(url);
        } else {
            this.getHTMLObjectElement().setData(url);
        }
    }

    @Override
    public boolean isJavaApplet() {
        String type = this.getElement().getAttribute("type");
        return type.equals("application/x-java-applet");
    }

    @Override
    public String getURLAttrName() {
        if (this.isJavaApplet()) {
            return "value";
        }
        return "data";
    }

    @Override
    public boolean isURLAttribute(Attr attr) {
        String attrName = this.getURLAttrName();
        if (this.isJavaApplet()) {
            HTMLParamElement srcParam = this.getHTMLParamElementWithSrc();
            return attr.getOwnerElement() == srcParam && attrName.equals(attr.getName());
        }
        return attrName.equals(attr.getName());
    }

    @Override
    public void setURL(String url, ClientDocumentStfulImpl clientDoc) {
        String oldURL = this.getURL();
        super.setURL(url, clientDoc);
        if (clientDoc.getBrowser() instanceof BrowserMSIEOld && !this.isJavaApplet()) {
            HTMLParamElement param;
            HTMLObjectElement elem = this.getHTMLObjectElement();
            if (elem.getAttribute("src").equals(oldURL)) {
                elem.setAttribute("src", url);
            }
            if ((param = this.getHTMLParamElementWithSrc()) != null && param.getValue().equals(oldURL)) {
                param.setValue(url);
            }
        }
    }
}

