/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.doc;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulOwnerImpl;
import org.itsnat.impl.core.doc.ElementDocContainerWrapperImpl;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.domimpl.ElementDocContainer;
import org.itsnat.impl.core.util.HasUniqueId;
import org.itsnat.impl.core.util.UniqueId;
import org.w3c.dom.Document;

public class BoundElementDocContainerImpl
implements HasUniqueId,
Serializable {
    protected ItsNatStfulDocumentImpl itsNatDoc;
    protected ElementDocContainerWrapperImpl elemWrap;
    protected String docName;
    protected UniqueId idObj;
    protected int randomNumber;
    protected ItsNatDocumentImpl contentItsNatDoc;
    protected String urlOriginal;

    public BoundElementDocContainerImpl(ElementDocContainer elem, String docName, ItsNatStfulDocumentImpl itsNatDoc) {
        this.elemWrap = elem.getElementDocContainerWrapper();
        this.docName = docName;
        this.itsNatDoc = itsNatDoc;
        this.idObj = itsNatDoc.getUniqueIdGenerator().generateUniqueId("dc");
        this.randomNumber = itsNatDoc.getRandom().nextInt();
        this.elemWrap.setBoundElementDocContainer(this);
    }

    @Override
    public String getId() {
        return this.idObj.getId();
    }

    @Override
    public UniqueId getUniqueId() {
        return this.idObj;
    }

    public ElementDocContainerWrapperImpl getElementDocContainerWrapper() {
        return this.elemWrap;
    }

    public ElementDocContainer getElementDocContainer() {
        if (this.elemWrap == null) {
            return null;
        }
        return this.elemWrap.getElementDocContainer();
    }

    public String getDocName() {
        return this.docName;
    }

    public int getRandomNumber() {
        return this.randomNumber;
    }

    public String getURLOriginal() {
        return this.urlOriginal;
    }

    public void saveURLOriginal(String urlOriginal) {
        this.urlOriginal = urlOriginal;
    }

    public ItsNatStfulDocumentImpl getItsNatStfulDocument() {
        return this.itsNatDoc;
    }

    public ItsNatDocumentImpl getContentItsNatDocument() {
        return this.contentItsNatDoc;
    }

    public void setContentItsNatDocument(ItsNatDocumentImpl contentItsNatDoc) {
        if (this.contentItsNatDoc != null) {
            this.contentItsNatDoc.setParentHTMLDocContainer(null);
        }
        this.contentItsNatDoc = contentItsNatDoc;
        if (contentItsNatDoc != null) {
            contentItsNatDoc.setParentHTMLDocContainer(this);
        }
    }

    public Document getContentDocument() {
        if (this.contentItsNatDoc == null) {
            return null;
        }
        return this.contentItsNatDoc.getDocument();
    }

    protected static String getNameFromQuery(URL urlObj) {
        String docName = null;
        String query = urlObj.getQuery();
        String token = query.indexOf(38) != -1 ? "&" : null;
        String[] params = token != null ? query.split(token) : new String[]{query};
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            int pos = param.indexOf(61);
            String name = param.substring(0, pos);
            String value = param.substring(pos + 1);
            if (name.equals("itsnat_doc_name")) {
                if (docName != null) {
                    throw new ItsNatException("Unexpected duplication of itsnat_doc_name parameter");
                }
                docName = value;
                continue;
            }
            if (!name.equals("itsnat_action")) continue;
            docName = null;
            break;
        }
        return docName;
    }

    public static BoundElementDocContainerImpl register(ElementDocContainer elem, ItsNatStfulDocumentImpl itsNatDoc) {
        String urlOriginal;
        String url = urlOriginal = elem.getElementDocContainerWrapper().getURL();
        if ((url = url.trim()).equals("")) {
            return null;
        }
        String docName = null;
        try {
            if (url.startsWith("?")) {
                StringBuilder path = new StringBuilder();
                path.append("http://localhost:8080/context/servlet");
                path.append(url);
                URL urlObj = new URL(path.toString());
                docName = BoundElementDocContainerImpl.getNameFromQuery(urlObj);
            } else {
                URL urlObj = new URL(url);
                URL urlDocObj = new URL(itsNatDoc.getRequestURL());
                if (!urlDocObj.getProtocol().equals(urlObj.getProtocol())) {
                    return null;
                }
                if (!urlDocObj.getHost().equals(urlObj.getHost())) {
                    return null;
                }
                if (urlDocObj.getPort() != urlObj.getPort()) {
                    return null;
                }
                if (!urlDocObj.getPath().equals(urlObj.getPath())) {
                    return null;
                }
                docName = BoundElementDocContainerImpl.getNameFromQuery(urlObj);
            }
        }
        catch (Exception ex) {
            return null;
        }
        if (docName == null) {
            return null;
        }
        return itsNatDoc.addBoundElementDocContainer(elem, docName);
    }

    public static boolean unRegister(ElementDocContainer elem, ItsNatStfulDocumentImpl itsNatDoc) {
        BoundElementDocContainerImpl bindInfo = elem.getElementDocContainerWrapper().getBoundElementDocContainer();
        if (bindInfo == null) {
            return false;
        }
        bindInfo.unRegister();
        return true;
    }

    public void unRegister() {
        if (this.elemWrap == null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        this.setContentItsNatDocument(null);
        this.itsNatDoc.removeBoundElementDocContainer(this);
        this.elemWrap.setBoundElementDocContainer(null);
        this.elemWrap = null;
    }

    protected static URL buildAbsURLUntilQuery(String url, StringBuilder newURL) {
        String path;
        URL urlObj;
        try {
            urlObj = new URL(url);
        }
        catch (IOException ex) {
            throw new ItsNatException(ex);
        }
        newURL.append(urlObj.getProtocol());
        newURL.append(":");
        String authority = urlObj.getAuthority();
        if (authority != null && authority.length() > 0) {
            newURL.append("//");
            newURL.append(authority);
        }
        if ((path = urlObj.getPath()) != null) {
            newURL.append(path);
        }
        return urlObj;
    }

    public String generateURLForClientOwner(ClientDocumentStfulOwnerImpl clientDoc) {
        URL urlObj;
        String urlOriginal;
        String url = urlOriginal = this.elemWrap.getURL();
        url = url.trim();
        StringBuilder newURL = new StringBuilder();
        if (url.startsWith("?")) {
            StringBuilder urlAbs = new StringBuilder();
            urlAbs.append("http://localhost:8080/context/servlet");
            urlAbs.append(url);
            try {
                urlObj = new URL(urlAbs.toString());
            }
            catch (IOException ex) {
                throw new ItsNatException(ex);
            }
            newURL.append("?" + urlObj.getQuery());
        } else {
            urlObj = BoundElementDocContainerImpl.buildAbsURLUntilQuery(url, newURL);
            newURL.append("?" + urlObj.getQuery());
            String stdSessionId = clientDoc.getItsNatSessionImpl().getStandardSessionId();
            newURL.append("&itsnat_jsessionid_parent=" + stdSessionId);
        }
        newURL.append("&itsnat_doc_parent_id=" + this.itsNatDoc.getId());
        newURL.append("&itsnat_element_parent_id=" + this.getId());
        newURL.append("&itsnat_element_sec_num=" + this.getRandomNumber());
        String ref = urlObj.getRef();
        if (ref != null) {
            newURL.append("#" + ref);
        }
        return newURL.toString();
    }

    public String generateURLForClientAttached(ClientDocumentAttachedClientImpl clientDocParent) {
        String urlOriginal;
        String url = urlOriginal = this.elemWrap.getURL();
        url = url.trim();
        StringBuilder newURL = new StringBuilder();
        URL urlObj = null;
        if (url.startsWith("?")) {
            try {
                urlObj = new URL("http://localhost:8080/context/servlet" + url);
            }
            catch (IOException ex) {
                throw new ItsNatException(ex);
            }
            newURL.append("?itsnat_action=attach_client");
        } else {
            urlObj = BoundElementDocContainerImpl.buildAbsURLUntilQuery(url, newURL);
            newURL.append("?itsnat_action=attach_client");
            String stdSessionId = clientDocParent.getItsNatSessionImpl().getStandardSessionId();
            newURL.append("&itsnat_jsessionid_parent=" + stdSessionId);
        }
        newURL.append("&itsnat_client_parent_id=" + clientDocParent.getId());
        newURL.append("&itsnat_element_parent_id=" + this.getId());
        newURL.append("&itsnat_element_sec_num=" + this.getRandomNumber());
        String ref = urlObj.getRef();
        if (ref != null) {
            newURL.append("#" + ref);
        }
        return newURL.toString();
    }

    public void setURLForClientOwner(ClientDocumentStfulOwnerImpl clientDoc) {
        if (this.itsNatDoc.getDocMutationEventListener().isEnabled()) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        this.saveURLOriginal(this.elemWrap.getURL());
        String newURL = this.generateURLForClientOwner(clientDoc);
        this.setURL(newURL, clientDoc);
    }

    public void setURLForClientAttached(ClientDocumentAttachedClientImpl clientDoc) {
        if (this.itsNatDoc.getDocMutationEventListener().isEnabled()) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        this.saveURLOriginal(this.elemWrap.getURL());
        String newURL = this.generateURLForClientAttached(clientDoc);
        this.setURL(newURL, clientDoc);
    }

    public void restoreOriginalURL(ClientDocumentStfulImpl clientDoc) {
        if (this.itsNatDoc.getDocMutationEventListener().isEnabled()) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        this.setURL(this.getURLOriginal(), clientDoc);
    }

    protected void setURL(String url, ClientDocumentStfulImpl clientDoc) {
        this.elemWrap.setURL(url, clientDoc);
    }
}

