/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.css.lex;

import java.io.Serializable;
import java.util.LinkedList;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.css.lex.Colon;
import org.itsnat.impl.core.css.lex.Comma;
import org.itsnat.impl.core.css.lex.Cursor;
import org.itsnat.impl.core.css.lex.FloatNumber;
import org.itsnat.impl.core.css.lex.HexNumber;
import org.itsnat.impl.core.css.lex.Identifier;
import org.itsnat.impl.core.css.lex.ParenthesisBlock;
import org.itsnat.impl.core.css.lex.Percent;
import org.itsnat.impl.core.css.lex.SemiColon;
import org.itsnat.impl.core.css.lex.Space;
import org.itsnat.impl.core.css.lex.StringDoubleQuote;
import org.itsnat.impl.core.css.lex.StringSimpleQuote;

public abstract class Token
implements Serializable {
    protected int start;
    protected int end;

    public Token(int start) {
        this.start = start;
    }

    public Token() {
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public static LinkedList<Token> parse(String code) {
        Cursor cursor = new Cursor(code);
        return Token.parse(cursor, false, ' ');
    }

    public static LinkedList<Token> parse(Cursor cursor, boolean checkEndChar, char endChar) {
        LinkedList<Token> tokens = new LinkedList<Token>();
        while (cursor.isValidPosition()) {
            Token token;
            int i = cursor.getCurrentPos();
            char c = cursor.getCurrentChar();
            if (checkEndChar && c == endChar) break;
            if (Space.isSpace(c)) {
                token = new Space(c, i);
            } else if (c == ';') {
                token = new SemiColon(i);
            } else if (c == ',') {
                token = new Comma(i);
            } else if (c == '(') {
                token = new ParenthesisBlock(cursor);
            } else if (c == '\"') {
                token = new StringDoubleQuote(cursor);
            } else if (c == '\'') {
                token = new StringSimpleQuote(cursor);
            } else if (c == ':') {
                token = new Colon(i);
            } else if (c == '%') {
                token = new Percent(i);
            } else if (Identifier.isIdentifierStart(c)) {
                token = new Identifier(cursor);
            } else if (FloatNumber.isFloatNumberStart(c)) {
                token = new FloatNumber(cursor);
            } else if (HexNumber.isHexNumberStart(c)) {
                token = new HexNumber(cursor);
            } else {
                throw new ItsNatException("Unexpected char, pos: " + cursor.getCurrentPos() + " code: " + cursor.getCode());
            }
            tokens.add(token);
            cursor.inc();
        }
        return tokens;
    }

    public boolean equals(Object token) {
        if (super.equals(token)) {
            return true;
        }
        if (!this.getClass().equals(token.getClass())) {
            return false;
        }
        return this.toString().equals(token.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

