/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.css.lex;

import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.css.lex.Cursor;
import org.itsnat.impl.core.css.lex.Token;

public abstract class StringLiteral
extends Token {
    protected String value = "";

    public StringLiteral(Cursor cursor) {
        super(cursor.getCurrentPos());
        this.parse(cursor);
    }

    public String toString() {
        char c = this.getDelimiterChar();
        return c + this.value + c;
    }

    public abstract char getDelimiterChar();

    public void parse(Cursor cursor) {
        int end;
        StringBuilder valueTmp = new StringBuilder();
        cursor.inc();
        char endChar = this.getDelimiterChar();
        while (cursor.isValidPosition() && endChar != cursor.getCurrentChar()) {
            valueTmp.append(cursor.getCurrentChar());
            cursor.inc();
        }
        this.value = valueTmp.toString();
        if (cursor.isInTheEnd()) {
            throw new ItsNatException("Missing matching " + endChar + " start pos: " + this.start + " code: \"" + cursor.getCode() + "\"");
        }
        this.end = end = cursor.getCurrentPos();
    }
}

