/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.css.lex;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;
import org.itsnat.impl.core.css.lex.Space;
import org.itsnat.impl.core.css.lex.Token;

public class SourceCode
implements Serializable {
    protected LinkedList<Token> tokens;
    protected StringBuilder code;

    public SourceCode(String code) {
        this.tokens = Token.parse(code);
        this.code = new StringBuilder(code);
    }

    public SourceCode() {
        this.tokens = new LinkedList();
        this.code = new StringBuilder();
    }

    public SourceCode(LinkedList<Token> tokens) {
        this.tokens = tokens;
        this.code = new StringBuilder(SourceCode.toStringTokens(tokens));
    }

    public SourceCode(String code, LinkedList<Token> tokens) {
        this.code = new StringBuilder(code);
        this.tokens = tokens;
    }

    public static SourceCode newSourceCode(String code) {
        return new SourceCode(code);
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (!(other instanceof SourceCode)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void addToken(Token token) {
        this.tokens.add(token);
        this.code.append(token.toString());
    }

    public int tokenCount() {
        return this.tokens.size();
    }

    public Token getToken(int i) {
        return this.tokens.get(i);
    }

    public String toString() {
        return this.code.toString();
    }

    public String toStringTokens() {
        return SourceCode.toStringTokens(this.tokens);
    }

    public static String toStringTokens(LinkedList<Token> tokens) {
        StringBuilder code = new StringBuilder();
        for (Token token : tokens) {
            code.append(token.toString());
        }
        return code.toString();
    }

    public SourceCode[] split(Token byTok) {
        SourceCode current;
        SourceCode[] resTmp = new SourceCode[this.tokens.size() / 2 + 1];
        resTmp[0] = current = new SourceCode();
        int i = 0;
        for (Token token : this.tokens) {
            if (token.equals(byTok)) {
                if (current.tokenCount() > 0) {
                    ++i;
                }
                resTmp[i] = current = new SourceCode();
                continue;
            }
            current.addToken(token);
        }
        if (current.tokenCount() == 0) {
            --i;
        }
        SourceCode[] res = new SourceCode[i + 1];
        for (int j = 0; j <= i; ++j) {
            res[j] = resTmp[j];
        }
        return res;
    }

    public SourceCode trim() {
        Token token;
        LinkedList<Token> resTokens = new LinkedList<Token>();
        resTokens.addAll(this.tokens);
        boolean modified = false;
        ListIterator it = resTokens.listIterator();
        while (it.hasNext() && (token = (Token)it.next()).getClass().equals(Space.class)) {
            it.remove();
            modified = true;
        }
        it = resTokens.listIterator(resTokens.size());
        while (it.hasPrevious() && (token = (Token)it.previous()).getClass().equals(Space.class)) {
            it.remove();
            modified = true;
        }
        if (modified) {
            return new SourceCode(resTokens);
        }
        return new SourceCode(this.code.toString(), resTokens);
    }
}

