/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.css.lex;

import org.itsnat.impl.core.css.lex.Cursor;
import org.itsnat.impl.core.css.lex.Token;

public class HexNumber
extends Token {
    protected String value = "";

    public HexNumber(Cursor cursor) {
        super(cursor.getCurrentPos());
        this.parse(cursor);
    }

    public static boolean isHexNumberStart(char c) {
        return c == '#';
    }

    public static boolean isHexNumberPart(char c) {
        if ('0' <= c && c <= '9') {
            return true;
        }
        return 'a' <= (c = Character.toLowerCase(c)) && c <= 'f';
    }

    public String toString() {
        return this.value;
    }

    public static int toIntFromHex(String s) {
        return Integer.parseInt(s, 16);
    }

    public static int toIntFromHex(char c) {
        return HexNumber.toIntFromHex(Character.toString(c));
    }

    public void parse(Cursor cursor) {
        StringBuilder valueTmp = new StringBuilder();
        valueTmp.append(cursor.getCurrentChar());
        int i = cursor.inc();
        while (cursor.isValidPosition() && HexNumber.isHexNumberPart(cursor.getCurrentChar())) {
            valueTmp.append(cursor.getCurrentChar());
            i = cursor.inc();
        }
        this.value = valueTmp.toString();
        cursor.dec();
        this.end = cursor.getCurrentPos();
    }
}

