/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.css.lex;

import org.itsnat.impl.core.css.lex.Cursor;
import org.itsnat.impl.core.css.lex.Token;

public class FloatNumber
extends Token {
    protected String value = "";

    public FloatNumber(Cursor cursor) {
        super(cursor.getCurrentPos());
        this.parse(cursor);
    }

    public static boolean isFloatNumberStart(char c) {
        return c == '.' || c == '+' || c == '-' || Character.isDigit(c);
    }

    public static boolean isFloatNumberPart(char c) {
        return c == '.' || Character.isDigit(c);
    }

    public String toString() {
        return this.value;
    }

    public float getFloat() {
        return Float.parseFloat(this.value);
    }

    public void parse(Cursor cursor) {
        StringBuilder valueTmp = new StringBuilder();
        valueTmp.append(cursor.getCurrentChar());
        int i = cursor.inc();
        while (cursor.isValidPosition() && FloatNumber.isFloatNumberPart(cursor.getCurrentChar())) {
            valueTmp.append(cursor.getCurrentChar());
            i = cursor.inc();
        }
        this.value = valueTmp.toString();
        cursor.dec();
        this.end = cursor.getCurrentPos();
    }
}

