/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.css.lex;

import org.itsnat.core.ItsNatException;

public class Cursor {
    protected int pos = 0;
    protected String code;

    public Cursor(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public int getLength() {
        return this.code.length();
    }

    public boolean isFirstPos() {
        return this.pos == 0;
    }

    public boolean isLastPos() {
        return this.pos == this.getLength() - 1;
    }

    public boolean isInTheEnd() {
        return this.pos == this.getLength();
    }

    public boolean isValidPosition() {
        if (this.isInTheEnd()) {
            return false;
        }
        return this.getLength() != 0;
    }

    public boolean hasNext() {
        return this.pos + 1 <= this.getLength() - 1;
    }

    public char getCurrentChar() {
        int i = this.getCurrentPos();
        return this.code.charAt(i);
    }

    public char getNextChar() {
        int i = this.getCurrentPos();
        return this.code.charAt(i + 1);
    }

    public int getCurrentPos() {
        if (!this.isValidPosition()) {
            if (this.getLength() == 0) {
                throw new ItsNatException("INTERNAL ERROR: code is empty");
            }
            if (this.isInTheEnd()) {
                throw new ItsNatException("INTERNAL ERROR: cursor in the end");
            }
        }
        return this.pos;
    }

    public int inc() {
        if (this.isInTheEnd()) {
            throw new ItsNatException("INTERNAL ERROR: cursor is already in the end");
        }
        ++this.pos;
        return this.pos;
    }

    public int dec() {
        if (this.isFirstPos()) {
            throw new ItsNatException("INTERNAL ERROR: cursor is already in first position");
        }
        --this.pos;
        return this.pos;
    }
}

