/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.css.lex;

import java.util.LinkedList;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.css.lex.Cursor;
import org.itsnat.impl.core.css.lex.SourceCode;
import org.itsnat.impl.core.css.lex.Token;

public abstract class Block
extends Token {
    protected SourceCode content;

    public Block(Cursor cursor) {
        super(cursor.getCurrentPos());
        this.parse(cursor);
    }

    public void parse(Cursor cursor) {
        int end;
        cursor.inc();
        char endChar = this.getEndBlockChar();
        LinkedList<Token> tokens = Token.parse(cursor, true, endChar);
        if (cursor.isInTheEnd()) {
            throw new ItsNatException("Missing matching " + endChar + " start pos: " + this.start + " code: \"" + cursor.getCode() + "\"");
        }
        this.end = end = cursor.getCurrentPos();
        this.content = new SourceCode(tokens);
    }

    public abstract char getBeginBlockChar();

    public abstract char getEndBlockChar();

    public String toString() {
        return "(" + this.content.toString() + ")";
    }

    public SourceCode getContent() {
        return this.content;
    }
}

