/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.css;

import org.itsnat.impl.core.css.CSSPrimitiveValueImpl;
import org.itsnat.impl.core.css.CSSPrimitiveValueLiteralImpl;
import org.itsnat.impl.core.css.lex.Comma;
import org.itsnat.impl.core.css.lex.SourceCode;
import org.itsnat.impl.core.css.lex.Space;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Rect;

public class RectImpl
extends CSSPrimitiveValueLiteralImpl
implements Rect {
    protected CSSPrimitiveValueImpl parent;
    protected CSSPrimitiveValueImpl top;
    protected CSSPrimitiveValueImpl right;
    protected CSSPrimitiveValueImpl bottom;
    protected CSSPrimitiveValueImpl left;

    public RectImpl(SourceCode cssTextCode, CSSPrimitiveValueImpl parent) {
        this.parent = parent;
        SourceCode[] rectList = cssTextCode.split(Comma.getSingleton());
        if (rectList.length != 4 && (rectList = cssTextCode.split(new Space(' '))).length != 4) {
            throw new DOMException(15, "Rect syntax error, property: " + this.getPropertyName() + " value: " + cssTextCode.toString());
        }
        this.top = new CSSPrimitiveValueImpl(rectList[0], 0, this);
        this.right = new CSSPrimitiveValueImpl(rectList[1], 1, this);
        this.bottom = new CSSPrimitiveValueImpl(rectList[2], 2, this);
        this.left = new CSSPrimitiveValueImpl(rectList[3], 3, this);
    }

    @Override
    public int getCode() {
        return 1;
    }

    @Override
    public CSSPrimitiveValue getTop() {
        return this.top;
    }

    @Override
    public CSSPrimitiveValue getRight() {
        return this.right;
    }

    @Override
    public CSSPrimitiveValue getBottom() {
        return this.bottom;
    }

    @Override
    public CSSPrimitiveValue getLeft() {
        return this.left;
    }

    @Override
    public String getPropertyName() {
        return this.parent.getPropertyName();
    }

    @Override
    public Object getUpdatedChildObjectValueFromElement(Object requester, int requesterCode) {
        Rect current = (Rect)this.parent.getUpdatedChildObjectValueFromElement(this, this.getCode());
        if (current != this) {
            if (requesterCode == 0) {
                return current.getTop();
            }
            if (requesterCode == 1) {
                return current.getRight();
            }
            if (requesterCode == 2) {
                return current.getBottom();
            }
            if (requesterCode == 3) {
                return current.getLeft();
            }
            throw new DOMException(15, "Internal Error");
        }
        return requester;
    }

    @Override
    public void notifyToElementChangedCSSText(SourceCode cssText, Object requester) {
        String topValue = this.top.getCssTextSourceCode(false).toString();
        String rightValue = this.right.getCssTextSourceCode(false).toString();
        String bottomValue = this.bottom.getCssTextSourceCode(false).toString();
        String leftValue = this.left.getCssTextSourceCode(false).toString();
        String cssTextRect = "rect(" + topValue + "," + rightValue + "," + bottomValue + "," + leftValue + ")";
        SourceCode cssTextRectCode = new SourceCode(cssTextRect);
        this.parent.setCssTextSourceCode(cssTextRectCode, true);
    }
}

