/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.css;

import org.itsnat.impl.core.css.CSSPrimitiveValueImpl;
import org.itsnat.impl.core.css.CSSPrimitiveValueLiteralImpl;
import org.itsnat.impl.core.css.ObjectValueParent;
import org.itsnat.impl.core.css.lex.Comma;
import org.itsnat.impl.core.css.lex.HexNumber;
import org.itsnat.impl.core.css.lex.SourceCode;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.RGBColor;

public class RGBColorImpl
extends CSSPrimitiveValueLiteralImpl
implements RGBColor,
ObjectValueParent {
    protected CSSPrimitiveValueImpl parent;
    protected CSSPrimitiveValueImpl red;
    protected CSSPrimitiveValueImpl green;
    protected CSSPrimitiveValueImpl blue;

    public RGBColorImpl(SourceCode cssTextCode, CSSPrimitiveValueImpl parent) {
        this.parent = parent;
        SourceCode[] colorList = cssTextCode.split(Comma.getSingleton());
        if (colorList.length != 3) {
            throw new DOMException(15, "RGBColor syntax error, property: " + this.getPropertyName() + " value: " + cssTextCode.toString());
        }
        this.createColors(colorList);
    }

    public RGBColorImpl(HexNumber token, CSSPrimitiveValueImpl parent) {
        this.parent = parent;
        String color = token.toString();
        SourceCode[] colorList = new SourceCode[3];
        if (color.length() == 4) {
            char r = color.charAt(1);
            colorList[0] = SourceCode.newSourceCode(Integer.toString(HexNumber.toIntFromHex(r)));
            char g = color.charAt(1);
            colorList[1] = SourceCode.newSourceCode(Integer.toString(HexNumber.toIntFromHex(g)));
            char b = color.charAt(2);
            colorList[2] = SourceCode.newSourceCode(Integer.toString(HexNumber.toIntFromHex(b)));
        } else if (color.length() == 7) {
            String r = color.substring(1, 3);
            colorList[0] = SourceCode.newSourceCode(Integer.toString(HexNumber.toIntFromHex(r)));
            String g = color.substring(3, 5);
            colorList[1] = SourceCode.newSourceCode(Integer.toString(HexNumber.toIntFromHex(g)));
            String b = color.substring(5, 7);
            colorList[2] = SourceCode.newSourceCode(Integer.toString(HexNumber.toIntFromHex(b)));
        } else {
            throw new DOMException(15, "RGBColor syntax error, property: " + this.getPropertyName() + " value: " + color);
        }
        this.createColors(colorList);
    }

    @Override
    public int getCode() {
        return 2;
    }

    private void createColors(SourceCode[] colorList) {
        this.red = new CSSPrimitiveValueImpl(colorList[0], 0, this);
        this.green = new CSSPrimitiveValueImpl(colorList[1], 1, this);
        this.blue = new CSSPrimitiveValueImpl(colorList[2], 2, this);
    }

    @Override
    public CSSPrimitiveValue getRed() {
        return this.red;
    }

    @Override
    public CSSPrimitiveValue getGreen() {
        return this.green;
    }

    @Override
    public CSSPrimitiveValue getBlue() {
        return this.blue;
    }

    @Override
    public String getPropertyName() {
        return this.parent.getCSSValueParent().getPropertyName();
    }

    @Override
    public Object getUpdatedChildObjectValueFromElement(Object requester, int requesterCode) {
        RGBColor current = (RGBColor)this.parent.getUpdatedChildObjectValueFromElement(this, this.getCode());
        if (current != this) {
            if (requesterCode == 0) {
                return current.getRed();
            }
            if (requesterCode == 1) {
                return current.getGreen();
            }
            if (requesterCode == 2) {
                return current.getBlue();
            }
            throw new DOMException(15, "Internal Error");
        }
        return requester;
    }

    @Override
    public void notifyToElementChangedCSSText(SourceCode cssTextCode, Object requester) {
        String cssTextRGB = "rgb(" + this.red.getCssTextSourceCode(false) + "," + this.green.getCssTextSourceCode(false) + "," + this.blue.getCssTextSourceCode(false) + ")";
        SourceCode cssTextRGBCode = new SourceCode(cssTextRGB);
        this.parent.setCssTextSourceCode(cssTextRGBCode, true);
    }
}

