/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.css;

import java.util.ArrayList;
import java.util.List;
import org.itsnat.impl.core.css.CSSValueImpl;
import org.itsnat.impl.core.css.ObjectValueParent;
import org.itsnat.impl.core.css.lex.SourceCode;
import org.itsnat.impl.core.css.lex.Space;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class CSSValueListImpl
extends CSSValueImpl
implements CSSValueList {
    protected List<CSSValueImpl> values = new ArrayList<CSSValueImpl>();

    public CSSValueListImpl(SourceCode cssTextCode, SourceCode[] parts, int code, ObjectValueParent parent) {
        super(cssTextCode, code, parent);
        this.rebuild(parts);
    }

    @Override
    public int getLength() {
        return this.values.size();
    }

    @Override
    public CSSValue item(int index) {
        return this.values.get(index);
    }

    @Override
    public short getCssValueType() {
        return 2;
    }

    @Override
    public void rebuild(SourceCode cssTextCode) {
        this.values.clear();
        SourceCode[] parts = cssTextCode.split(new Space(' '));
        this.rebuild(parts);
    }

    public void rebuild(SourceCode[] parts) {
        this.values.clear();
        for (int i = 0; i < parts.length; ++i) {
            CSSValueImpl item = CSSValueImpl.newCSSValue(parts[i], i, this);
            this.values.add(item);
        }
    }

    @Override
    public Object getUpdatedChildObjectValueFromElement(Object requester, int requesterCode) {
        CSSValueListImpl current = (CSSValueListImpl)this.parent.getUpdatedChildObjectValueFromElement(this, this.getCode());
        if (current != this) {
            if (current.getLength() != this.getLength()) {
                throw new DOMException(15, "Changed the number of values");
            }
            return current.item(requesterCode);
        }
        return requester;
    }

    @Override
    public void notifyToElementChangedCSSText(SourceCode cssText, Object requester) {
        StringBuilder parentCssText = new StringBuilder();
        for (int i = 0; i < this.values.size(); ++i) {
            if (i != 0) {
                parentCssText.append(" ");
            }
            CSSValueImpl valueItem = this.values.get(i);
            parentCssText.append(valueItem.getCssTextSourceCode(false).toString());
        }
        this.cssTextCode = new SourceCode(parentCssText.toString());
        this.parent.notifyToElementChangedCSSText(this.cssTextCode, this);
    }
}

