/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.css;

import java.io.Serializable;
import org.itsnat.impl.core.css.CSSPrimitiveValueImpl;
import org.itsnat.impl.core.css.CSSValueInheritImpl;
import org.itsnat.impl.core.css.CSSValueListImpl;
import org.itsnat.impl.core.css.ObjectValueParent;
import org.itsnat.impl.core.css.lex.SourceCode;
import org.itsnat.impl.core.css.lex.Space;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

public abstract class CSSValueImpl
implements CSSValue,
ObjectValueParent,
Serializable {
    protected SourceCode cssTextCode;
    protected ObjectValueParent parent;
    protected int code;

    public CSSValueImpl(SourceCode cssTextCode, int code, ObjectValueParent parent) {
        this.cssTextCode = cssTextCode;
        this.code = code;
        this.parent = parent;
    }

    public static CSSValueImpl newCSSValue(SourceCode cssTextCode, int code, ObjectValueParent parent) {
        if (CSSValueInheritImpl.isCSSValueInherit(cssTextCode)) {
            return new CSSValueInheritImpl(cssTextCode, code, parent);
        }
        SourceCode cssTextCodeTmp = cssTextCode;
        SourceCode[] parts = (cssTextCodeTmp = cssTextCodeTmp.trim()).split(new Space(' '));
        if (parts.length > 1) {
            return new CSSValueListImpl(cssTextCode, parts, code, parent);
        }
        return new CSSPrimitiveValueImpl(cssTextCode, code, parent);
    }

    public int getCode() {
        return this.code;
    }

    public ObjectValueParent getCSSValueParent() {
        return this.parent;
    }

    public abstract void rebuild(SourceCode var1);

    @Override
    public String getCssText() {
        return this.getCssTextSourceCode(true).toString();
    }

    public SourceCode getCssTextSourceCode(boolean checkFromElem) {
        CSSValueImpl current;
        if (checkFromElem && (current = (CSSValueImpl)this.parent.getUpdatedChildObjectValueFromElement(this, this.getCode())) != this && !this.cssTextCode.equals(current.getCssTextSourceCode(false))) {
            throw new DOMException(15, "CSS property " + this.parent.getPropertyName() + " has been indirectly changed");
        }
        return this.cssTextCode;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.setCssTextSourceCode(new SourceCode(cssText), true);
    }

    public void setCssTextSourceCode(SourceCode cssTextCode, boolean rebuild) throws DOMException {
        if (!this.cssTextCode.equals(cssTextCode)) {
            this.cssTextCode = cssTextCode;
            if (rebuild) {
                this.rebuild(cssTextCode);
            }
        }
        this.parent.notifyToElementChangedCSSText(cssTextCode, this);
    }

    @Override
    public abstract short getCssValueType();

    @Override
    public String getPropertyName() {
        return this.parent.getPropertyName();
    }
}

