/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.css;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.itsnat.impl.core.css.CSSPropertyImpl;
import org.itsnat.impl.core.css.lex.SemiColon;
import org.itsnat.impl.core.css.lex.SourceCode;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public abstract class CSSStyleDeclarationImpl
implements CSSStyleDeclaration,
Serializable {
    protected String cssText = "";
    protected Element parent;
    protected Map<String, CSSPropertyImpl> propertyMap = new HashMap<String, CSSPropertyImpl>();
    protected List<CSSPropertyImpl> propertyList = new ArrayList<CSSPropertyImpl>();

    public CSSStyleDeclarationImpl(Element parent) {
        this.parent = parent;
    }

    @Override
    public String getCssText() {
        this.rebuild();
        return this.cssText;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        DOMUtilInternal.setAttribute(this.parent, "style", cssText);
        this.rebuild(cssText);
    }

    public CSSPropertyImpl getPropertyObject(String propertyName) {
        this.getCssText();
        propertyName = propertyName.toLowerCase();
        return this.propertyMap.get(propertyName);
    }

    @Override
    public String getPropertyValue(String propertyName) {
        CSSPropertyImpl property = this.getPropertyObject(propertyName);
        if (property == null) {
            return "";
        }
        return property.getCssTextSourceCode(false).toString();
    }

    @Override
    public CSSValue getPropertyCSSValue(String propertyName) {
        CSSPropertyImpl property = this.getPropertyObject(propertyName);
        if (property == null) {
            return null;
        }
        return property.getCSSValue();
    }

    @Override
    public String removeProperty(String propertyName) throws DOMException {
        CSSPropertyImpl property = this.getPropertyObject(propertyName = propertyName.toLowerCase());
        if (property == null) {
            return "";
        }
        String res = property.getCssTextSourceCode(false).toString();
        this.propertyList.remove(property);
        this.propertyMap.remove(propertyName);
        this.updateCssTextFromPropertyList();
        return res;
    }

    public void updateCssTextFromPropertyList() {
        StringBuilder cssText = new StringBuilder();
        for (int i = 0; i < this.propertyList.size(); ++i) {
            if (i != 0) {
                cssText.append(';');
            }
            CSSPropertyImpl currProperty = this.propertyList.get(i);
            cssText.append(currProperty.getPropertyName() + ":" + currProperty.getCssTextSourceCode(false));
        }
        this.cssText = cssText.toString();
        this.setCssText(this.cssText);
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        return "";
    }

    public void notifyToElementChangedProperty(CSSPropertyImpl property, SourceCode value) {
        CSSPropertyImpl propertyElem = this.getPropertyObject(property.getPropertyName());
        if (propertyElem != null) {
            if (propertyElem != property) {
                this.addCSSProperty(property, true);
            } else {
                this.updateCssTextFromPropertyList();
            }
        } else {
            this.addCSSProperty(property, true);
        }
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        CSSPropertyImpl property = this.getPropertyObject(propertyName);
        if (property != null) {
            String currentValue = property.getCssText(false);
            if (!currentValue.equals(value)) {
                property.setCssText(value, false);
                this.updateCssTextFromPropertyList();
            }
        } else {
            this.addCSSProperty(propertyName, value, true);
        }
    }

    @Override
    public int getLength() {
        return this.propertyList.size();
    }

    @Override
    public String item(int index) {
        CSSPropertyImpl currProperty = this.propertyList.get(index);
        return currProperty.getCssTextSourceCode().toString();
    }

    @Override
    public CSSRule getParentRule() {
        return null;
    }

    private void rebuild() {
        String cssText = this.parent.getAttribute("style");
        this.rebuild(cssText);
    }

    private void addCSSProperty(String propertyName, String value, boolean updateCssText) {
        CSSPropertyImpl property = new CSSPropertyImpl(propertyName, value, this);
        this.addCSSProperty(property, updateCssText);
    }

    private void addCSSProperty(CSSPropertyImpl property, boolean updateCssText) {
        this.propertyList.add(property);
        this.propertyMap.put(property.getPropertyName(), property);
        if (updateCssText) {
            this.updateCssTextFromPropertyList();
        }
    }

    private void rebuild(String cssText) {
        if (this.cssText.equals(cssText)) {
            return;
        }
        this.cssText = cssText;
        this.propertyList.clear();
        this.propertyMap.clear();
        SourceCode cssTextSource = SourceCode.newSourceCode(cssText);
        SourceCode[] cssTextSourceProps = cssTextSource.split(SemiColon.getSingleton());
        for (int i = 0; i < cssTextSourceProps.length; ++i) {
            SourceCode cssTextSourceProp = cssTextSourceProps[i];
            this.addCSSProperty(new CSSPropertyImpl(cssTextSourceProp, this), false);
        }
    }
}

