/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.css;

import java.io.Serializable;
import org.itsnat.impl.core.css.CSSStyleDeclarationImpl;
import org.itsnat.impl.core.css.CSSValueImpl;
import org.itsnat.impl.core.css.ObjectValueParent;
import org.itsnat.impl.core.css.lex.Colon;
import org.itsnat.impl.core.css.lex.Identifier;
import org.itsnat.impl.core.css.lex.SourceCode;
import org.w3c.dom.DOMException;

public class CSSPropertyImpl
implements ObjectValueParent,
Serializable {
    protected String propertyName;
    protected CSSValueImpl value;
    protected CSSStyleDeclarationImpl parent;
    protected SourceCode cssTextValue;

    public CSSPropertyImpl(SourceCode cssTextProp, CSSStyleDeclarationImpl parent) {
        SourceCode[] pairNameValue = cssTextProp.split(Colon.getSingleton());
        if (pairNameValue.length < 2) {
            throw new DOMException(15, "Missing : or missing name-value, code: " + cssTextProp.toString());
        }
        if (pairNameValue.length > 2) {
            throw new DOMException(15, "CSS: unexpected \":\" , code: " + cssTextProp.toString());
        }
        SourceCode srcPropName = pairNameValue[0];
        if ((srcPropName = srcPropName.trim()).tokenCount() > 1) {
            throw new DOMException(15, "CSS: syntax error , code: " + srcPropName.toString());
        }
        if (!(srcPropName.getToken(0) instanceof Identifier)) {
            throw new DOMException(15, "CSS: expected an identifier: " + srcPropName.toString());
        }
        String propertyName = srcPropName.toString();
        this.propertyName = propertyName = propertyName.toLowerCase();
        this.cssTextValue = pairNameValue[1];
        this.parent = parent;
    }

    public CSSPropertyImpl(String propertyName, String cssText, CSSStyleDeclarationImpl parent) {
        propertyName = propertyName.trim();
        this.propertyName = propertyName = propertyName.toLowerCase();
        this.cssTextValue = new SourceCode(cssText);
        this.parent = parent;
    }

    public String getCssText(boolean updateIfNeeded) {
        SourceCode sourceCode = this.getCssTextSourceCode(updateIfNeeded);
        return sourceCode.toString();
    }

    public void setCssText(String value, boolean updateParent) {
        this.setCssTextSourceCode(new SourceCode(value), updateParent);
    }

    public SourceCode getCssTextSourceCode() {
        return this.getCssTextSourceCode(true);
    }

    public SourceCode getCssTextSourceCode(boolean updateIfNeeded) {
        if (updateIfNeeded) {
            this.rebuild();
        }
        return this.cssTextValue;
    }

    public void setCssTextSourceCode(SourceCode cssText, boolean updateParent) {
        this.rebuild(cssText);
        if (updateParent) {
            this.parent.notifyToElementChangedProperty(this, cssText);
        }
    }

    public CSSValueImpl getCSSValue() {
        if (this.value == null) {
            this.value = CSSValueImpl.newCSSValue(this.cssTextValue, -1, this);
        }
        return this.value;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Object getUpdatedChildObjectValueFromElement(Object requester, int requesterCode) {
        return this.parent.getPropertyCSSValue(this.propertyName);
    }

    public void rebuild() {
        CSSPropertyImpl property = this.parent.getPropertyObject(this.propertyName);
        if (property != this) {
            SourceCode cssText = property.getCssTextSourceCode(false);
            this.rebuild(cssText);
        }
    }

    public void rebuild(SourceCode cssText) {
        if (this.cssTextValue.equals(cssText)) {
            return;
        }
        this.cssTextValue = cssText;
        this.value = null;
    }

    @Override
    public void notifyToElementChangedCSSText(SourceCode cssText, Object requester) {
        this.setCssTextSourceCode(cssText, true);
    }
}

