/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.css;

import org.itsnat.impl.core.css.CSSValueImpl;
import org.itsnat.impl.core.css.ObjectValueParent;
import org.itsnat.impl.core.css.RGBColorImpl;
import org.itsnat.impl.core.css.RectImpl;
import org.itsnat.impl.core.css.lex.FloatNumber;
import org.itsnat.impl.core.css.lex.HexNumber;
import org.itsnat.impl.core.css.lex.Identifier;
import org.itsnat.impl.core.css.lex.ParenthesisBlock;
import org.itsnat.impl.core.css.lex.Percent;
import org.itsnat.impl.core.css.lex.SourceCode;
import org.itsnat.impl.core.css.lex.StringDoubleQuote;
import org.itsnat.impl.core.css.lex.StringSimpleQuote;
import org.itsnat.impl.core.css.lex.Token;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class CSSPrimitiveValueImpl
extends CSSValueImpl
implements CSSPrimitiveValue {
    protected short primitiveType = (short)-1;
    protected float floatValue;
    protected Counter counterValue;
    protected Rect rectValue;
    protected RGBColor rgbValue;

    public CSSPrimitiveValueImpl(SourceCode cssTextCode, int code, ObjectValueParent parent) {
        super(cssTextCode, code, parent);
        this.rebuild(cssTextCode);
    }

    public static String floatUnitToString(short unitType) {
        switch (unitType) {
            case 2: {
                return "%";
            }
            case 15: {
                return "s";
            }
            case 3: {
                return "em";
            }
            case 4: {
                return "ex";
            }
            case 5: {
                return "px";
            }
            case 6: {
                return "cm";
            }
            case 7: {
                return "mm";
            }
            case 8: {
                return "in";
            }
            case 9: {
                return "pt";
            }
            case 10: {
                return "pc";
            }
            case 14: {
                return "ms";
            }
            case 16: {
                return "hz";
            }
            case 11: {
                return "deg";
            }
            case 12: {
                return "rad";
            }
            case 17: {
                return "khz";
            }
            case 13: {
                return "grad";
            }
            case 1: {
                return "";
            }
            case 18: {
                return "";
            }
        }
        throw new DOMException(15, "Invalid unit type: " + unitType);
    }

    public boolean setFloatValueInternal(SourceCode cssTextCode) {
        Token token0 = cssTextCode.getToken(0);
        if (!(token0 instanceof FloatNumber)) {
            return false;
        }
        FloatNumber tokenNumber = (FloatNumber)token0;
        float floatValue = tokenNumber.getFloat();
        int unitType = -1;
        if (cssTextCode.tokenCount() > 2) {
            throw new DOMException(15, "CSS: number format error: " + cssTextCode.toString());
        }
        if (cssTextCode.tokenCount() == 1) {
            unitType = 1;
        } else {
            Token token1 = cssTextCode.getToken(1);
            if (!(token1 instanceof Identifier) && !(token1 instanceof Percent)) {
                throw new DOMException(15, "CSS: expected a unit identifier: " + cssTextCode.toString());
            }
            String suffix = token1.toString();
            unitType = "%".equals(suffix = suffix.toLowerCase()) ? 2 : ("s".equals(suffix) ? 2 : ("em".equals(suffix) ? 3 : ("ex".equals(suffix) ? 4 : ("px".equals(suffix) ? 5 : ("cm".equals(suffix) ? 6 : ("mm".equals(suffix) ? 7 : ("in".equals(suffix) ? 8 : ("pt".equals(suffix) ? 9 : ("pc".equals(suffix) ? 10 : ("ms".equals(suffix) ? 14 : ("hz".equals(suffix) ? 16 : ("deg".equals(suffix) ? 11 : ("rad".equals(suffix) ? 12 : ("khz".equals(suffix) ? 17 : ("grad".equals(suffix) ? 13 : 18)))))))))))))));
        }
        this.primitiveType = (short)unitType;
        this.floatValue = floatValue;
        return true;
    }

    public boolean setFunctionBasedValueInternal(SourceCode cssTextCode) {
        if (cssTextCode.tokenCount() != 2) {
            return false;
        }
        Token token0 = cssTextCode.getToken(0);
        if (!(token0 instanceof Identifier)) {
            return false;
        }
        Identifier tokIdent = (Identifier)token0;
        Token token1 = cssTextCode.getToken(1);
        if (!(token1 instanceof ParenthesisBlock)) {
            return false;
        }
        ParenthesisBlock tokBlock = (ParenthesisBlock)token1;
        String identif = tokIdent.toString();
        if ((identif = identif.toLowerCase()).equals("url")) {
            this.primitiveType = (short)20;
            return true;
        }
        if (identif.equals("rect")) {
            this.primitiveType = (short)24;
            this.rectValue = new RectImpl(tokBlock.getContent(), this);
            return true;
        }
        if (identif.equals("rgb")) {
            this.primitiveType = (short)25;
            this.rgbValue = new RGBColorImpl(tokBlock.getContent(), this);
            return true;
        }
        if (identif.equals("attr")) {
            this.primitiveType = (short)22;
            return true;
        }
        if (identif.equals("counter")) {
            this.primitiveType = 0;
            return true;
        }
        if (identif.equals("counters")) {
            this.primitiveType = 0;
            return true;
        }
        return false;
    }

    @Override
    public void rebuild(SourceCode cssTextCode) {
        if ((cssTextCode = cssTextCode.trim()).tokenCount() == 0) {
            throw new DOMException(15, "CSS value is not specified, property: " + this.parent.getPropertyName() + " value: " + this.cssTextCode.toString());
        }
        if (this.setFloatValueInternal(cssTextCode)) {
            return;
        }
        if (this.setFunctionBasedValueInternal(cssTextCode)) {
            return;
        }
        if (cssTextCode.tokenCount() == 1) {
            Token token = cssTextCode.getToken(0);
            if (token instanceof StringDoubleQuote || token instanceof StringSimpleQuote) {
                this.primitiveType = (short)19;
                return;
            }
            if (token instanceof Identifier) {
                this.primitiveType = (short)21;
                return;
            }
            if (token instanceof HexNumber) {
                this.primitiveType = (short)25;
                this.rgbValue = new RGBColorImpl((HexNumber)token, this);
                return;
            }
            this.primitiveType = 0;
            return;
        }
        this.primitiveType = 0;
    }

    @Override
    public short getCssValueType() {
        return 1;
    }

    @Override
    public short getPrimitiveType() {
        return this.primitiveType;
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        if (this.primitiveType != unitType) {
            throw new DOMException(15, "Unit conversions is not supported");
        }
        this.getCssText();
        return this.floatValue;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        String suffix = CSSPrimitiveValueImpl.floatUnitToString(unitType);
        String cssText = Float.toString(floatValue) + suffix;
        this.setCssTextSourceCode(new SourceCode(cssText), false);
        this.primitiveType = unitType;
        this.floatValue = floatValue;
    }

    public static boolean isStringBasedType(short primitiveType) {
        return primitiveType == 19 || primitiveType == 20 || primitiveType == 21 || primitiveType == 22;
    }

    @Override
    public String getStringValue() throws DOMException {
        if (!CSSPrimitiveValueImpl.isStringBasedType(this.primitiveType)) {
            throw new DOMException(15, "CSS value doesn't contain a string");
        }
        String str = this.getCssText();
        str = str.trim();
        if (this.primitiveType == 19) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        if (!CSSPrimitiveValueImpl.isStringBasedType(this.primitiveType)) {
            throw new DOMException(15, "CSS value doesn't contain a string");
        }
        if (!CSSPrimitiveValueImpl.isStringBasedType(stringType)) {
            throw new DOMException(15, "New CSS value doesn't contain a string, invalid string type");
        }
        stringValue = stringValue.trim();
        if (this.primitiveType == 19) {
            stringValue = '\"' + stringValue + '\"';
        }
        this.setCssTextSourceCode(new SourceCode(stringValue), false);
        this.primitiveType = stringType;
    }

    @Override
    public Counter getCounterValue() throws DOMException {
        if (this.primitiveType != 23) {
            throw new DOMException(15, "CSS value doesn't contain a Counter value");
        }
        return this.counterValue;
    }

    @Override
    public Rect getRectValue() throws DOMException {
        if (this.primitiveType != 24) {
            throw new DOMException(15, "CSS value doesn't contain a Rect value");
        }
        return this.rectValue;
    }

    @Override
    public RGBColor getRGBColorValue() throws DOMException {
        if (this.primitiveType != 25) {
            throw new DOMException(15, "CSS value doesn't contain a RGBColor value");
        }
        return this.rgbValue;
    }

    @Override
    public Object getUpdatedChildObjectValueFromElement(Object requester, int requesterCode) {
        CSSPrimitiveValueImpl current = (CSSPrimitiveValueImpl)this.parent.getUpdatedChildObjectValueFromElement(this, this.getCode());
        if (current != this) {
            if (requesterCode == 0) {
                return current.getCounterValue();
            }
            if (requesterCode == 1) {
                return current.getRectValue();
            }
            if (requesterCode == 2) {
                return current.getRGBColorValue();
            }
            throw new DOMException(15, "INTERNAL ERROR");
        }
        return requester;
    }

    @Override
    public void notifyToElementChangedCSSText(SourceCode cssText, Object requester) {
        this.setCssTextSourceCode(cssText, false);
    }
}

