/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.conv;

import java.util.HashMap;
import java.util.Map;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.conv.StringToBooleanConverter;
import org.itsnat.impl.core.conv.StringToByteConverter;
import org.itsnat.impl.core.conv.StringToCharacterConverter;
import org.itsnat.impl.core.conv.StringToDoubleConverter;
import org.itsnat.impl.core.conv.StringToFloatConverter;
import org.itsnat.impl.core.conv.StringToIntegerConverter;
import org.itsnat.impl.core.conv.StringToLongConverter;
import org.itsnat.impl.core.conv.StringToShortConverter;
import org.itsnat.impl.core.conv.StringToStringConverter;

public abstract class StringToObjectConverter {
    public static final Map<Class<?>, StringToObjectConverter> converters = new HashMap();

    public static void addConverter(StringToObjectConverter conv) {
        converters.put(conv.getClassTarget(), conv);
        Class<?> wrapper = conv.getClassTargetWrapper();
        if (wrapper != null) {
            converters.put(wrapper, conv);
        }
    }

    public static Object convert(String value, Class<?> type) {
        if (value == null) {
            throw new ItsNatException("Unexpected null value");
        }
        StringToObjectConverter conv = converters.get(type);
        if (conv == null) {
            throw new ItsNatException("Class type not supported: " + type.getName());
        }
        return conv.convert(value);
    }

    public abstract Class<?> getClassTarget();

    public abstract Class<?> getClassTargetWrapper();

    public abstract Object convert(String var1);

    static {
        StringToObjectConverter.addConverter(new StringToStringConverter());
        StringToObjectConverter.addConverter(new StringToBooleanConverter());
        StringToObjectConverter.addConverter(new StringToByteConverter());
        StringToObjectConverter.addConverter(new StringToCharacterConverter());
        StringToObjectConverter.addConverter(new StringToShortConverter());
        StringToObjectConverter.addConverter(new StringToIntegerConverter());
        StringToObjectConverter.addConverter(new StringToLongConverter());
        StringToObjectConverter.addConverter(new StringToFloatConverter());
        StringToObjectConverter.addConverter(new StringToDoubleConverter());
    }
}

