/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.comet;

import java.util.LinkedList;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.event.ParamTransport;
import org.itsnat.impl.core.CommModeImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.comet.CometNotifierImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.event.ItsNatEventListenerChainImpl;
import org.itsnat.impl.core.event.client.dom.domext.ClientItsNatNormalCometEventImpl;
import org.itsnat.impl.core.listener.EventListenerSerializableInternal;
import org.itsnat.impl.core.listener.EventListenerUtil;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class NormalCometNotifierImpl
extends CometNotifierImpl {
    protected long eventTimeout;
    protected LinkedList<EventListener> normalEventListeners;
    protected EventListener listenerDispatcher;
    protected int commMode;
    protected ParamTransport[] extraParams;
    protected String preSendCode;

    public NormalCometNotifierImpl(int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout, ClientDocumentStfulImpl clientDoc) {
        super(true, clientDoc);
        if (!CommModeImpl.isPureAsyncMode(commMode)) {
            throw new ItsNatException("Communication transport mode must be pure asynchronous");
        }
        this.commMode = commMode;
        this.extraParams = extraParams;
        this.preSendCode = preSendCode;
        this.eventTimeout = eventTimeout;
        this.listenerDispatcher = new EventListenerSerializableInternal(){

            @Override
            public void handleEvent(Event evt) {
                ClientItsNatNormalCometEventImpl cometEvt;
                ItsNatEventListenerChainImpl chain;
                if (NormalCometNotifierImpl.this.hasEventListenerListeners() && NormalCometNotifierImpl.this.getEventListenerList(chain = (cometEvt = (ClientItsNatNormalCometEventImpl)evt).getItsNatEventListenerChainImpl())) {
                    EventListenerUtil.handleEventListeners((Event)cometEvt, chain);
                }
            }
        };
        clientDoc.addCometNotifier(this);
        clientDoc.addCometTask(this, extraParams, preSendCode);
    }

    public int getCommMode() {
        return this.commMode;
    }

    @Override
    public void addCometTask() {
        this.getClientDocumentStful().addCometTask(this, this.extraParams, this.preSendCode);
    }

    @Override
    public long getEventTimeout() {
        return this.eventTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopInternal() {
        ItsNatStfulDocumentImpl itsNatDoc;
        super.stopInternal();
        ClientDocumentStfulImpl clientDoc = this.getClientDocumentStful();
        ItsNatStfulDocumentImpl itsNatStfulDocumentImpl = itsNatDoc = this.getItsNatStfulDocument();
        synchronized (itsNatStfulDocumentImpl) {
            clientDoc.removeCometNotifier(this);
        }
    }

    public EventListener getEventListenerDispatcher() {
        return this.listenerDispatcher;
    }

    public boolean hasEventListenerListeners() {
        if (this.normalEventListeners == null) {
            return false;
        }
        return !this.normalEventListeners.isEmpty();
    }

    public LinkedList<EventListener> getEventListenerList() {
        if (this.normalEventListeners == null) {
            this.normalEventListeners = new LinkedList();
        }
        return this.normalEventListeners;
    }

    public boolean getEventListenerList(ItsNatEventListenerChainImpl<EventListener> chain) {
        return chain.addFirstListenerList(this.normalEventListeners);
    }

    @Override
    public void addEventListener(EventListener listener) {
        LinkedList<EventListener> normalEventListeners = this.getEventListenerList();
        normalEventListeners.add(listener);
    }

    @Override
    public void removeEventListener(EventListener listener) {
        LinkedList<EventListener> normalEventListeners = this.getEventListenerList();
        normalEventListeners.remove(listener);
    }
}

