/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.comet;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.itsnat.core.ClientDocument;
import org.itsnat.core.CometNotifier;
import org.itsnat.core.ItsNatDocument;
import org.itsnat.impl.core.ItsNatUserDataImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;

public abstract class CometNotifierImpl
extends ItsNatUserDataImpl
implements CometNotifier {
    protected boolean started = true;
    protected transient Object monitor = new Object();
    protected boolean pendingNotification = false;
    protected long expirationDelay = 3600000L;
    protected ClientDocumentStfulImpl clientDoc;

    public CometNotifierImpl(boolean userDataSync, ClientDocumentStfulImpl clientDoc) {
        super(userDataSync);
        this.clientDoc = clientDoc;
    }

    protected void finalize() {
        this.stop();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.monitor = new Object();
        in.defaultReadObject();
    }

    @Override
    public ClientDocument getClientDocument() {
        return this.clientDoc;
    }

    public abstract void addCometTask();

    public Object getMonitor() {
        return this.monitor;
    }

    @Override
    public void notifyClient() {
        if (this.isStopped()) {
            return;
        }
        this.wakeup();
    }

    @Override
    public void stop() {
        if (this.isStopped()) {
            return;
        }
        this.stopInternal();
    }

    public void stopInternal() {
        this.started = false;
        this.wakeup();
        this.pendingNotification = false;
    }

    @Override
    public boolean isStopped() {
        return !this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.monitor;
        synchronized (object) {
            this.pendingNotification = true;
            this.monitor.notifyAll();
        }
    }

    public boolean hasPendingNotification() {
        return this.pendingNotification;
    }

    public void setPendingNotification(boolean pendingNotification) {
        this.pendingNotification = pendingNotification;
    }

    public ClientDocumentStfulImpl getClientDocumentStful() {
        return this.clientDoc;
    }

    @Override
    public ItsNatDocument getItsNatDocument() {
        return this.getItsNatStfulDocument();
    }

    public ItsNatStfulDocumentImpl getItsNatStfulDocument() {
        return this.clientDoc.getItsNatStfulDocument();
    }

    @Override
    public long getExpirationDelay() {
        return this.expirationDelay;
    }

    @Override
    public void setExpirationDelay(long expirationDelay) {
        this.expirationDelay = expirationDelay;
    }
}

