/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.clientdoc.web;

import java.io.Serializable;
import org.itsnat.impl.core.browser.web.BrowserW3C;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.domutil.NamespaceUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGWebInfoImpl
implements Serializable {
    protected ClientDocumentStfulDelegateWebImpl clientDoc;
    protected boolean forceFlash;
    protected int metaForceFlashPos;

    public SVGWebInfoImpl(ClientDocumentStfulDelegateWebImpl clientDoc, boolean forceFlash, int metaForceFlashPos) {
        this.clientDoc = clientDoc;
        this.forceFlash = forceFlash;
        this.metaForceFlashPos = metaForceFlashPos;
    }

    public boolean isForceFlash() {
        return this.forceFlash;
    }

    public boolean hasMetaForceFlash() {
        return this.metaForceFlashPos >= 0;
    }

    public int getMetaForceFlashPos() {
        return this.metaForceFlashPos;
    }

    public boolean isUsingSVGWebFlash() {
        if (this.isForceFlash()) {
            return true;
        }
        BrowserWeb browser = this.clientDoc.getBrowserWeb();
        return !(browser instanceof BrowserW3C);
    }

    public boolean isSVGRootElementProcessedBySVGWebFlash(Element elem) {
        if (!this.isUsingSVGWebFlash()) {
            return false;
        }
        if (!NamespaceUtil.isSVGRootElement(elem)) {
            return false;
        }
        String svgEngine = elem.getAttributeNS("http://itsnat.org/itsnat", "svgengine");
        if (svgEngine.equals("svgweb")) {
            return true;
        }
        svgEngine = elem.getAttribute("svgengine");
        return svgEngine.equals("svgweb");
    }

    public boolean isSVGNodeProcessedBySVGWebFlash(Node node) {
        if (!this.isUsingSVGWebFlash()) {
            return false;
        }
        Element rootElem = NamespaceUtil.getSVGRootElement(node);
        if (rootElem == null) {
            return false;
        }
        return this.isSVGRootElementProcessedBySVGWebFlash(rootElem);
    }

    public static boolean isSVGRootElementProcessedBySVGWebFlash(Element elem, ClientDocumentStfulDelegateWebImpl clientDoc) {
        SVGWebInfoImpl svgWebInfo = clientDoc.getSVGWebInfo();
        if (svgWebInfo == null) {
            return false;
        }
        return svgWebInfo.isSVGRootElementProcessedBySVGWebFlash(elem);
    }

    public static boolean isSVGNodeProcessedBySVGWebFlash(Node node, ClientDocumentStfulDelegateWebImpl clientDoc) {
        SVGWebInfoImpl svgWebInfo = clientDoc.getSVGWebInfo();
        if (svgWebInfo == null) {
            return false;
        }
        return svgWebInfo.isSVGNodeProcessedBySVGWebFlash(node);
    }

    public static boolean isSVGWebEnabled(ClientDocumentStfulDelegateWebImpl clientDoc) {
        SVGWebInfoImpl svgWebInfo = clientDoc.getSVGWebInfo();
        return svgWebInfo != null;
    }
}

