/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.clientdoc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NodeCacheRegistryImpl
implements Serializable {
    protected ClientDocumentStfulDelegateImpl clientDoc;
    protected Map<Node, String> mapByNode = new HashMap<Node, String>();
    protected Map<String, Node> mapById = new HashMap<String, Node>();

    public NodeCacheRegistryImpl(ClientDocumentStfulDelegateImpl clientDoc) {
        this.clientDoc = clientDoc;
    }

    public ClientDocumentStfulImpl getClientDocumentStful() {
        return this.clientDoc.getClientDocumentStful();
    }

    public ClientDocumentStfulDelegateImpl getClientDocumentStfulDelegate() {
        return this.clientDoc;
    }

    public ItsNatStfulDocumentImpl getItsNatStfulDocument() {
        return this.clientDoc.getItsNatStfulDocument();
    }

    public Iterator<Map.Entry<Node, String>> iterator() {
        return this.mapByNode.entrySet().iterator();
    }

    private static boolean isNodeTypeCacheable(Node node) {
        short type = node.getNodeType();
        if (type == 1) {
            return true;
        }
        if (type == 3) {
            return false;
        }
        if (type == 9) {
            return false;
        }
        if (type == -1) {
            return false;
        }
        return type != 10;
    }

    public static boolean isCacheableNode(Node node, Document doc) {
        if (!NodeCacheRegistryImpl.isNodeTypeCacheable(node)) {
            return false;
        }
        return DOMUtilInternal.isNodeInside(node, doc);
    }

    public String removeNode(Node node) {
        if (!NodeCacheRegistryImpl.isNodeTypeCacheable(node)) {
            return null;
        }
        String id = this.mapByNode.remove(node);
        if (id == null) {
            return null;
        }
        this.mapById.remove(id);
        return id;
    }

    public String getId(Node node) {
        if (node == null) {
            return null;
        }
        if (!NodeCacheRegistryImpl.isNodeTypeCacheable(node)) {
            return null;
        }
        return this.mapByNode.get(node);
    }

    public Node getNodeById(String id) {
        return this.mapById.get(id);
    }

    public String generateUniqueId() {
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        return NodeCacheRegistryImpl.generateUniqueId(itsNatDoc);
    }

    public static String generateUniqueId(ItsNatStfulDocumentImpl itsNatDoc) {
        return itsNatDoc.getUniqueIdGenerator().generateId("cn");
    }

    public String addNode(Node node) {
        if (node == null) {
            throw new ItsNatException("Null node is not supported", (Object)this.clientDoc);
        }
        if (!NodeCacheRegistryImpl.isCacheableNode(node, this.getItsNatStfulDocument().getDocument())) {
            return null;
        }
        if (!this.clientDoc.getClientDocumentStful().isSendCodeEnabled()) {
            return null;
        }
        String id = this.generateUniqueId();
        this.addNode(node, id);
        return id;
    }

    public void addNode(Node node, String id) {
        if (node == null) {
            throw new ItsNatException("Null node is not supported", (Object)this.clientDoc);
        }
        String idOld = this.mapByNode.put(node, id);
        Node nodeOld = this.mapById.put(id, node);
        if (idOld != null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        if (nodeOld != null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
    }

    public boolean isEmpty() {
        boolean res = this.mapById.isEmpty();
        if (res != this.mapByNode.isEmpty()) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        return res;
    }

    public void clearCache() {
        this.mapById.clear();
        this.mapByNode.clear();
    }

    public ArrayList<LinkedList<Map.Entry<Node, String>>> getOrderedByHeight() {
        ArrayList<LinkedList<Map.Entry<Node, String>>> cacheCopy = new ArrayList<LinkedList<Map.Entry<Node, String>>>();
        Iterator<Map.Entry<Node, String>> it = this.iterator();
        while (it.hasNext()) {
            LinkedList<Map.Entry<Node, String>> sameH;
            Map.Entry<Node, String> entry = it.next();
            Node node = entry.getKey();
            int h = NodeCacheRegistryImpl.getNodeDeep(node);
            if (cacheCopy.size() <= h) {
                int currSize = cacheCopy.size();
                for (int i = 1; i <= h - currSize + 1; ++i) {
                    cacheCopy.add(null);
                }
            }
            if ((sameH = cacheCopy.get(h)) == null) {
                sameH = new LinkedList();
                cacheCopy.set(h, sameH);
            }
            sameH.add(entry);
        }
        return cacheCopy;
    }

    private static int getNodeDeep(Node node) {
        int i = 0;
        while (node != null) {
            ++i;
            node = node.getParentNode();
        }
        return i;
    }

    public String cacheNewNodeIfNeededAndGenId(Node newNode) {
        if (!this.clientDoc.getItsNatStfulDocument().isNewNodeDirectChildOfContentRoot(newNode)) {
            return null;
        }
        String id = this.addNode(newNode);
        return id != null ? "\"" + id + "\"" : "null";
    }
}

