/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.clientdoc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.event.CodeToSendListener;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.clientdoc.CodeListImpl;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.event.CodeToSendEventImpl;
import org.itsnat.impl.core.event.CodeToSendListenersImpl;
import org.itsnat.impl.core.listener.WaitForEventListenerImpl;
import org.itsnat.impl.core.scriptren.shared.node.InnerMarkupCodeImpl;

public class CodeToSendRegistryImpl
implements Serializable {
    protected transient LinkedList<Object> codeToSend = new LinkedList();
    protected ClientDocumentImpl clientDoc;
    protected CodeToSendListenersImpl codeToSendListeners;
    protected boolean enabledSendCode = true;

    public CodeToSendRegistryImpl(ClientDocumentImpl clientDoc) {
        this.clientDoc = clientDoc;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.codeToSend = new LinkedList();
        in.defaultReadObject();
    }

    public boolean isSendCodeEnabled() {
        ItsNatDocumentImpl itsNatDoc = this.clientDoc.getItsNatDocumentImpl();
        if (itsNatDoc != null && !itsNatDoc.isSendCodeEnabled()) {
            return false;
        }
        return this.enabledSendCode;
    }

    public void disableSendCode() {
        this.enabledSendCode = false;
    }

    public void enableSendCode() {
        this.enabledSendCode = true;
    }

    public void addCodeToSendListener(CodeToSendListener listener) {
        this.getCodeToSendListeners().addCodeToSendListener(listener);
    }

    public void removeCodeToSendListener(CodeToSendListener listener) {
        this.getCodeToSendListeners().removeCodeToSendListener(listener);
    }

    public boolean hasCodeToSendListeners() {
        if (this.codeToSendListeners == null) {
            return false;
        }
        return this.codeToSendListeners.hasCodeToSendListeners();
    }

    public CodeToSendListenersImpl getCodeToSendListeners() {
        if (this.codeToSendListeners == null) {
            this.codeToSendListeners = new CodeToSendListenersImpl(this);
        }
        return this.codeToSendListeners;
    }

    public Object getLastCodeToSend() {
        if (this.codeToSend.isEmpty()) {
            return null;
        }
        return this.getLastCodeToSend(this.codeToSend.getLast());
    }

    protected Object getLastCodeToSend(Object codeFragment) {
        if (codeFragment instanceof CodeListImpl) {
            return ((CodeListImpl)codeFragment).getLast(this);
        }
        return codeFragment;
    }

    public void addCodeToSend(Object code) {
        this.addCodeToSend(this.codeToSend.size(), code);
    }

    private void addCodeToSend(int index, Object code) {
        if (code == null) {
            return;
        }
        if (code instanceof String && ((String)code).equals("")) {
            return;
        }
        if (!this.clientDoc.isScriptingEnabled()) {
            throw new ItsNatException("Scripting is disabled", (Object)this);
        }
        if (!this.isSendCodeEnabled()) {
            throw new ItsNatException("Send Code is disabled", (Object)this);
        }
        CodeToSendEventImpl event = null;
        if (this.hasCodeToSendListeners() && (code = (event = this.getCodeToSendListeners().preProcessCodeToSend(code)).getCode()) == null) {
            return;
        }
        this.codeToSend.add(index, code);
        if (event != null) {
            this.getCodeToSendListeners().postProcessCodeToSend(event);
        }
    }

    public String getCodeToSendAndReset() {
        Object codeFragment;
        if (this.codeToSend.isEmpty()) {
            return "";
        }
        StringBuilder code = new StringBuilder();
        Iterator it = this.codeToSend.iterator();
        while (it.hasNext() && !((codeFragment = it.next()) instanceof WaitForEventListenerImpl)) {
            code.append(this.codeToString(codeFragment));
            it.remove();
        }
        return code.toString();
    }

    protected String codeToString(Object codeFragment) {
        if (codeFragment instanceof InnerMarkupCodeImpl) {
            return ((InnerMarkupCodeImpl)codeFragment).render(this.clientDoc);
        }
        if (codeFragment instanceof CodeListImpl) {
            return ((CodeListImpl)codeFragment).codeToString(this);
        }
        return codeFragment.toString();
    }

    public void removeWaitForEventListener(WaitForEventListenerImpl listener) {
        this.codeToSend.remove(listener);
    }
}

