/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.clientdoc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentMapAction;
import org.itsnat.impl.core.clientdoc.ClientDocumentMapImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;

public class ClientDocumentStfulMapImpl
extends ClientDocumentMapImpl {
    protected transient WeakHashMap<ClientDocumentImpl, Object> clientDocAttachedMap;

    public ClientDocumentStfulMapImpl(ItsNatStfulDocumentImpl itsNatDoc) {
        super(itsNatDoc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        HashMap<ClientDocumentImpl, Object> mapTmp = null;
        if (this.clientDocAttachedMap != null) {
            mapTmp = new HashMap<ClientDocumentImpl, Object>(this.clientDocAttachedMap);
        }
        out.writeObject(mapTmp);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Map mapTmp = (Map)in.readObject();
        if (mapTmp != null) {
            this.getClientDocumentAttachedClientMap().putAll(mapTmp);
        }
        in.defaultReadObject();
    }

    private boolean hasClientDocumentAttachedClient() {
        if (this.clientDocAttachedMap == null) {
            return false;
        }
        return !this.clientDocAttachedMap.isEmpty();
    }

    private Map<ClientDocumentImpl, Object> getClientDocumentAttachedClientMap() {
        if (this.clientDocAttachedMap == null) {
            this.clientDocAttachedMap = new WeakHashMap();
        }
        return this.clientDocAttachedMap;
    }

    @Override
    public Object get(ClientDocumentImpl clientDoc) {
        Object res = super.get(clientDoc);
        if (res != null) {
            return res;
        }
        Map<ClientDocumentImpl, Object> map = this.getClientDocumentAttachedClientMap();
        return map.get(clientDoc);
    }

    @Override
    public Object put(ClientDocumentImpl clientDoc, Object value) {
        if (clientDoc == this.getClientDocumentOwner()) {
            return super.put(clientDoc, value);
        }
        Map<ClientDocumentImpl, Object> map = this.getClientDocumentAttachedClientMap();
        return map.put(clientDoc, value);
    }

    @Override
    public Object remove(ClientDocumentImpl clientDoc) {
        Map<ClientDocumentImpl, Object> map = this.getClientDocumentAttachedClientMap();
        return map.remove(clientDoc);
    }

    @Override
    public int size() {
        int size = super.size();
        if (!this.hasClientDocumentAttachedClient()) {
            return size;
        }
        return size + this.getClientDocumentAttachedClientMap().size();
    }

    @Override
    public void fillAllValues(Object[] values) {
        super.fillAllValues(values);
        if (!this.hasClientDocumentAttachedClient()) {
            return;
        }
        Map<ClientDocumentImpl, Object> observerClients = this.getClientDocumentAttachedClientMap();
        int i = 1;
        Iterator<Object> it = observerClients.values().iterator();
        while (it.hasNext()) {
            Object value;
            values[i] = value = it.next();
            ++i;
        }
    }

    @Override
    public void execAction(ClientDocumentMapAction action) {
        super.execAction(action);
        if (!this.hasClientDocumentAttachedClient()) {
            return;
        }
        Map<ClientDocumentImpl, Object> observerClients = this.getClientDocumentAttachedClientMap();
        for (Map.Entry<ClientDocumentImpl, Object> entry : observerClients.entrySet()) {
            action.exec(entry.getKey(), entry.getValue());
        }
    }
}

