/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.clientdoc;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.itsnat.core.CometNotifier;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatTimer;
import org.itsnat.core.event.CodeToSendListener;
import org.itsnat.core.event.ParamTransport;
import org.itsnat.core.script.ScriptUtil;
import org.itsnat.impl.comp.iframe.HTMLIFrameFileUploadImpl;
import org.itsnat.impl.core.CommModeImpl;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.CodeToSendRegistryImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.comet.NormalCometNotifierImpl;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.doc.ItsNatTimerImpl;
import org.itsnat.impl.core.listener.CometTaskEventListenerWrapper;
import org.itsnat.impl.core.listener.ItsNatNormalEventListenerWrapperImpl;
import org.itsnat.impl.core.listener.dom.domext.ItsNatAsyncTaskEventListenerWrapperImpl;
import org.itsnat.impl.core.listener.dom.domext.ItsNatContinueEventListenerWrapperImpl;
import org.itsnat.impl.core.listener.dom.domext.ItsNatDOMEventStatelessListenerWrapperImpl;
import org.itsnat.impl.core.listener.dom.domext.ItsNatDOMExtEventListenerWrapperImpl;
import org.itsnat.impl.core.listener.dom.domext.ItsNatTimerEventListenerWrapperImpl;
import org.itsnat.impl.core.listener.dom.domext.ItsNatUserEventListenerWrapperImpl;
import org.itsnat.impl.core.registry.CometTaskRegistryImpl;
import org.itsnat.impl.core.registry.ItsNatAsyncTaskRegistryImpl;
import org.itsnat.impl.core.registry.ItsNatNormalCometTaskRegistryImpl;
import org.itsnat.impl.core.registry.dom.domext.ItsNatContinueEventListenerRegistryImpl;
import org.itsnat.impl.core.registry.dom.domext.ItsNatTimerEventListenerRegistryImpl;
import org.itsnat.impl.core.registry.dom.domext.ItsNatUserEventListenerRegistryImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.itsnat.impl.core.util.MapUniqueId;
import org.itsnat.impl.core.util.UniqueIdGenIntList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class ClientDocumentStfulImpl
extends ClientDocumentImpl {
    protected ItsNatStfulDocumentImpl itsNatDoc;
    protected CodeToSendRegistryImpl codeToSend = new CodeToSendRegistryImpl(this);
    protected String scriptLoadCode;
    protected ItsNatTimerEventListenerRegistryImpl timerListenerRegistry;
    protected ItsNatContinueEventListenerRegistryImpl continueListenerRegistry;
    protected ItsNatAsyncTaskRegistryImpl asyncTaskRegistry;
    protected ItsNatUserEventListenerRegistryImpl userListenerRegistry;
    protected Set<NormalCometNotifierImpl> cometNotifiers;
    protected ItsNatNormalCometTaskRegistryImpl cometTaskRegistry;
    protected ClientDocumentStfulDelegateImpl delegate;
    protected ScriptUtil scriptUtil;
    protected LinkedList<EventListener> globalEventListeners;

    public ClientDocumentStfulImpl(ItsNatStfulDocumentImpl itsNatDoc, Browser browser, ItsNatSessionImpl session) {
        super(browser, session);
        this.itsNatDoc = itsNatDoc;
        this.delegate = ClientDocumentStfulDelegateImpl.createClientDocumentStfulDelegate(this);
    }

    public UniqueIdGenIntList getUniqueIdGenerator() {
        return this.getItsNatDocumentImpl().getUniqueIdGenerator();
    }

    public ClientDocumentStfulDelegateImpl getClientDocumentStfulDelegate() {
        return this.delegate;
    }

    @Override
    public ItsNatDocumentImpl getItsNatDocumentImpl() {
        return this.getItsNatStfulDocument();
    }

    public ItsNatStfulDocumentImpl getItsNatStfulDocument() {
        return this.itsNatDoc;
    }

    public boolean canReceiveNormalEvents(ItsNatNormalEventListenerWrapperImpl evtListener) {
        if (evtListener instanceof ItsNatDOMEventStatelessListenerWrapperImpl) {
            return true;
        }
        return this.canReceiveNormalEvents(evtListener.getEventListenerOrProxy());
    }

    public abstract boolean isEventsEnabled();

    public abstract boolean canReceiveALLNormalEvents();

    public abstract boolean canReceiveSOMENormalEvents();

    public abstract boolean canReceiveNormalEvents(EventListener var1);

    public void normalEventReceivedInDocument() {
    }

    public int getCommMode() {
        return this.itsNatDoc.getCommMode();
    }

    public long getEventTimeout() {
        return this.itsNatDoc.getEventTimeout();
    }

    public void normalEventReceived() {
        this.lastEventTime = System.currentTimeMillis();
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        itsNatDoc.normalEventReceived(this);
    }

    public CodeToSendRegistryImpl getCodeToSendRegistry() {
        return this.codeToSend;
    }

    @Override
    public String getCodeToSendAndReset() {
        return this.getCodeToSendRegistry().getCodeToSendAndReset();
    }

    public Object getLastCodeToSend() {
        return this.getCodeToSendRegistry().getLastCodeToSend();
    }

    @Override
    public void addCodeToSend(Object code) {
        this.getCodeToSendRegistry().addCodeToSend(code);
    }

    @Override
    public boolean isSendCodeEnabled() {
        return this.getCodeToSendRegistry().isSendCodeEnabled();
    }

    @Override
    public void disableSendCode() {
        this.getCodeToSendRegistry().disableSendCode();
    }

    @Override
    public void enableSendCode() {
        this.getCodeToSendRegistry().enableSendCode();
    }

    @Override
    public void addCodeToSendListener(CodeToSendListener listener) {
        this.getCodeToSendRegistry().addCodeToSendListener(listener);
    }

    @Override
    public void removeCodeToSendListener(CodeToSendListener listener) {
        this.getCodeToSendRegistry().removeCodeToSendListener(listener);
    }

    public String getScriptLoadCode() {
        if (this.scriptLoadCode == null) {
            throw new ItsNatException("Script code on load was already loaded", (Object)this);
        }
        String code = this.scriptLoadCode;
        this.scriptLoadCode = null;
        return code;
    }

    public void setScriptLoadCode(String code) {
        this.scriptLoadCode = code;
    }

    public boolean hasContinueEventListeners() {
        if (this.continueListenerRegistry == null) {
            return false;
        }
        return !this.continueListenerRegistry.isEmpty();
    }

    public ItsNatContinueEventListenerRegistryImpl getContinueEventListenerRegistry() {
        if (this.continueListenerRegistry == null) {
            this.continueListenerRegistry = new ItsNatContinueEventListenerRegistryImpl(this);
        }
        return this.continueListenerRegistry;
    }

    @Override
    public void addContinueEventListener(EventTarget target, EventListener listener) {
        int commMode = this.getCommMode();
        long eventTimeout = this.getEventTimeout();
        this.addContinueEventListener(target, listener, commMode, null, null, eventTimeout);
    }

    @Override
    public void addContinueEventListener(EventTarget target, EventListener listener, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout) {
        this.addContinueEventListener(target, listener, commMode, extraParams, preSendCode, eventTimeout, null);
    }

    public void addContinueEventListener(EventTarget target, EventListener listener, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        this.getContinueEventListenerRegistry().addContinueEventListener(target, listener, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
    }

    public ItsNatContinueEventListenerWrapperImpl removeContinueEventListener(String id) {
        return this.getContinueEventListenerRegistry().removeContinueEventListenerById(id);
    }

    public int removeAllContinueEventListeners(EventTarget target, boolean updateClient) {
        if (!this.hasContinueEventListeners()) {
            return 0;
        }
        return this.getContinueEventListenerRegistry().removeAllItsNatContinueEventListeners(target, updateClient);
    }

    @Override
    public ItsNatTimer createItsNatTimer() {
        return new ItsNatTimerImpl(this);
    }

    public boolean hasItsNatTimerEventListeners() {
        if (this.timerListenerRegistry == null) {
            return false;
        }
        return !this.timerListenerRegistry.isEmpty();
    }

    public ItsNatTimerEventListenerRegistryImpl getItsNatTimerEventListenerRegistry() {
        if (this.timerListenerRegistry == null) {
            this.timerListenerRegistry = new ItsNatTimerEventListenerRegistryImpl(this);
        }
        return this.timerListenerRegistry;
    }

    public ItsNatTimerEventListenerWrapperImpl getTimerEventListenerById(String id) {
        return this.getItsNatTimerEventListenerRegistry().getItsNatTimerEventListenerById(id);
    }

    public int removeAllTimerEventListeners(EventTarget target, boolean updateClient) {
        if (!this.hasItsNatTimerEventListeners()) {
            return 0;
        }
        return this.getItsNatTimerEventListenerRegistry().removeAllItsNatTimerEventListeners(target, updateClient);
    }

    public ItsNatAsyncTaskRegistryImpl getAsyncTaskRegistry() {
        if (this.asyncTaskRegistry == null) {
            this.asyncTaskRegistry = new ItsNatAsyncTaskRegistryImpl(this);
        }
        return this.asyncTaskRegistry;
    }

    @Override
    public void addAsynchronousTask(Runnable task, EventListener listener) {
        int commMode = CommModeImpl.getPreferredPureAsyncMode(this);
        this.addAsynchronousTask(task, false, 0, null, listener, commMode, null, null, -1L);
    }

    @Override
    public void addAsynchronousTask(Runnable task, boolean lockDoc, int maxWait, EventTarget element, EventListener listener, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout) {
        this.addAsynchronousTask(task, lockDoc, maxWait, element, listener, commMode, extraParams, preSendCode, eventTimeout, null);
    }

    public void addAsynchronousTask(Runnable task, boolean lockDoc, int maxWait, EventTarget element, EventListener listener, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        this.getAsyncTaskRegistry().addAsynchronousTask(task, lockDoc, maxWait, element, listener, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
    }

    public ItsNatAsyncTaskEventListenerWrapperImpl removeAsynchronousTask(String id) {
        return this.getAsyncTaskRegistry().removeAsynchronousTask(id);
    }

    @Override
    public void addEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture) {
        int commMode = this.getCommMode();
        long eventTimeout = this.getEventTimeout();
        this.addEventListener(nodeTarget, type, listener, useCapture, commMode, null, null, eventTimeout, null);
    }

    @Override
    public void addEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, int commMode) {
        long eventTimeout = this.getEventTimeout();
        this.addEventListener(nodeTarget, type, listener, useCapture, commMode, null, null, eventTimeout, null);
    }

    @Override
    public void addEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, ParamTransport extraParam) {
        ParamTransport[] extraParams = new ParamTransport[]{extraParam};
        this.addEventListener(nodeTarget, type, listener, useCapture, extraParams);
    }

    @Override
    public void addEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, ParamTransport[] extraParams) {
        int commMode = this.getCommMode();
        long eventTimeout = this.getEventTimeout();
        this.addEventListener(nodeTarget, type, listener, useCapture, commMode, extraParams, null, eventTimeout, null);
    }

    @Override
    public void addEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, String preSendCode) {
        int commMode = this.getCommMode();
        long eventTimeout = this.getEventTimeout();
        this.addEventListener(nodeTarget, type, listener, useCapture, commMode, null, preSendCode, eventTimeout, null);
    }

    @Override
    public void addEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout) {
        this.addEventListener(nodeTarget, type, listener, useCapture, commMode, extraParams, preSendCode, eventTimeout, null);
    }

    @Override
    public void addEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        if (ItsNatDOMExtEventListenerWrapperImpl.isExtensionType(type)) {
            this.addDOMExtEventListener(nodeTarget, type, listener, useCapture, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
        } else {
            this.delegate.addPlatformEventListener(nodeTarget, type, listener, useCapture, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
        }
    }

    public void addDOMExtEventListener(EventTarget nodeTarget, String type, EventListener listener, boolean useCapture, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        if (useCapture) {
            throw new ItsNatException("Capturing is not allowed for this type:" + type, (Object)this);
        }
        if (ItsNatUserEventListenerWrapperImpl.isUserType(type)) {
            String name = ItsNatUserEventListenerWrapperImpl.getNameFromType(type, false);
            this.addUserEventListener(nodeTarget, name, listener, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
        } else if (ItsNatContinueEventListenerWrapperImpl.isContinueType(type)) {
            this.addContinueEventListener(nodeTarget, listener, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
        } else {
            throw new ItsNatException("This method is not allowed to register this event listener type:" + type, (Object)this);
        }
    }

    @Override
    public void addMutationEventListener(EventTarget target, EventListener listener, boolean useCapture, int commMode, String preSendCode, long eventTimeout) {
        this.addMutationEventListener(target, listener, useCapture, commMode, preSendCode, eventTimeout, null);
    }

    @Override
    public void addMutationEventListener(EventTarget nodeTarget, EventListener mutationListener, boolean useCapture) {
        this.delegate.addMutationEventListener(nodeTarget, mutationListener, useCapture);
    }

    @Override
    public void addMutationEventListener(EventTarget target, EventListener listener, boolean useCapture, int commMode, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        this.delegate.addMutationEventListener(target, listener, useCapture, commMode, preSendCode, eventTimeout, bindToCustomFunc);
    }

    @Override
    public void removeMutationEventListener(EventTarget target, EventListener listener, boolean useCapture) {
        this.delegate.removeMutationEventListener(target, listener, useCapture);
    }

    @Override
    public void removeEventListener(EventTarget target, String type, EventListener listener, boolean useCapture) {
        this.removeEventListener(target, type, listener, useCapture, true);
    }

    @Override
    public void removeEventListener(EventTarget target, String type, EventListener listener, boolean useCapture, boolean updateClient) {
        if (ItsNatDOMExtEventListenerWrapperImpl.isExtensionType(type)) {
            this.removeDOMExtEventListener(target, type, listener, useCapture, updateClient);
        } else {
            this.delegate.removePlatformEventListener(target, type, listener, useCapture, updateClient);
        }
    }

    public void removeDOMExtEventListener(EventTarget target, String type, EventListener listener, boolean useCapture, boolean updateClient) {
        if (useCapture) {
            return;
        }
        if (!ItsNatUserEventListenerWrapperImpl.isUserType(type)) {
            throw new ItsNatException("This method is not allowed to unregister this event listener type:" + type, (Object)this);
        }
        String name = ItsNatUserEventListenerWrapperImpl.getNameFromType(type, false);
        this.removeUserEventListener(target, name, listener, updateClient);
    }

    public boolean hasUserEventListeners() {
        if (this.userListenerRegistry == null) {
            return false;
        }
        return !this.userListenerRegistry.isEmpty();
    }

    public ItsNatUserEventListenerRegistryImpl getUserEventListenerRegistry() {
        if (this.userListenerRegistry == null) {
            this.userListenerRegistry = new ItsNatUserEventListenerRegistryImpl(this.getItsNatStfulDocument(), this);
        }
        return this.userListenerRegistry;
    }

    @Override
    public void addUserEventListener(EventTarget target, String name, EventListener listener, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout) {
        this.addUserEventListener(target, name, listener, commMode, extraParams, preSendCode, eventTimeout, null);
    }

    @Override
    public void addUserEventListener(EventTarget target, String name, EventListener listener) {
        this.addUserEventListener(target, name, listener, this.getCommMode(), null, null, this.getEventTimeout(), null);
    }

    @Override
    public void addUserEventListener(EventTarget target, String name, EventListener listener, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        this.getUserEventListenerRegistry().addItsNatUserEventListener(target, name, listener, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
    }

    public ItsNatUserEventListenerWrapperImpl getUserEventListenerById(String listenerId) {
        ItsNatUserEventListenerWrapperImpl listener = null;
        if (this.hasUserEventListeners()) {
            listener = this.getUserEventListenerRegistry().getItsNatUserEventListenerById(listenerId);
        }
        if (listener == null) {
            listener = this.itsNatDoc.getUserEventListenerById(listenerId);
        }
        return listener;
    }

    @Override
    public void removeUserEventListener(EventTarget target, String name, EventListener listener) {
        this.removeUserEventListener(target, name, listener, true);
    }

    public void removeUserEventListener(EventTarget target, String name, EventListener listener, boolean updateClient) {
        this.getUserEventListenerRegistry().removeItsNatUserEventListener(target, name, listener, updateClient);
    }

    public int removeAllUserEventListeners(EventTarget target, boolean updateClient) {
        if (!this.hasUserEventListeners()) {
            return 0;
        }
        return this.getUserEventListenerRegistry().removeAllItsNatUserEventListeners(target, updateClient);
    }

    @Override
    public boolean hasGlobalEventListenerListeners() {
        if (this.globalEventListeners == null) {
            return false;
        }
        return !this.globalEventListeners.isEmpty();
    }

    public LinkedList<EventListener> getGlobalEventListenerList() {
        if (this.globalEventListeners == null) {
            this.globalEventListeners = new LinkedList();
        }
        return this.globalEventListeners;
    }

    @Override
    public void getGlobalEventListenerList(LinkedList<EventListener> list) {
        if (this.globalEventListeners == null) {
            return;
        }
        list.addAll(this.globalEventListeners);
    }

    @Override
    public void addEventListener(EventListener listener) {
        LinkedList<EventListener> globalEventListeners = this.getGlobalEventListenerList();
        globalEventListeners.add(listener);
    }

    public void addEventListener(int index, EventListener listener) {
        LinkedList<EventListener> globalEventListeners = this.getGlobalEventListenerList();
        globalEventListeners.add(index, listener);
    }

    @Override
    public void removeEventListener(EventListener listener) {
        LinkedList<EventListener> globalEventListeners = this.getGlobalEventListenerList();
        globalEventListeners.remove(listener);
    }

    @Override
    public CometNotifier createCometNotifier() {
        long eventTimeout = this.getEventTimeout();
        return this.createCometNotifier(eventTimeout);
    }

    @Override
    public CometNotifier createCometNotifier(long eventTimeout) {
        int commMode = CommModeImpl.getPreferredPureAsyncMode(this);
        return this.createCometNotifier(commMode, eventTimeout);
    }

    @Override
    public CometNotifier createCometNotifier(int commMode, long eventTimeout) {
        return this.createCometNotifier(commMode, null, null, eventTimeout);
    }

    @Override
    public CometNotifier createCometNotifier(int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout) {
        return new NormalCometNotifierImpl(commMode, extraParams, preSendCode, eventTimeout, this);
    }

    public boolean hasCometNotifiers() {
        if (this.cometNotifiers == null) {
            return false;
        }
        return !this.cometNotifiers.isEmpty();
    }

    public Set<NormalCometNotifierImpl> getCometNotifierSet() {
        if (this.cometNotifiers == null) {
            this.cometNotifiers = new HashSet<NormalCometNotifierImpl>();
        }
        return this.cometNotifiers;
    }

    public void addCometNotifier(NormalCometNotifierImpl notifier) {
        this.getCometNotifierSet().add(notifier);
    }

    public void removeCometNotifier(NormalCometNotifierImpl notifier) {
        this.getCometNotifierSet().remove(notifier);
    }

    public CometTaskRegistryImpl getCometTaskRegistry() {
        if (this.cometTaskRegistry == null) {
            this.cometTaskRegistry = new ItsNatNormalCometTaskRegistryImpl(this);
        }
        return this.cometTaskRegistry;
    }

    public void addCometTask(NormalCometNotifierImpl notifier, ParamTransport[] extraParams, String preSendCode) {
        this.getCometTaskRegistry().addCometTask(notifier, extraParams, preSendCode);
    }

    public CometTaskEventListenerWrapper removeCometTask(String id) {
        return this.getCometTaskRegistry().removeCometTask(id);
    }

    @Override
    protected void setInvalidInternal() {
        ClientDocumentStfulDelegateWebImpl clientDocDeleg;
        super.setInvalidInternal();
        if (this.hasCometNotifiers()) {
            Set<NormalCometNotifierImpl> notifiers = this.getCometNotifierSet();
            NormalCometNotifierImpl[] array = notifiers.toArray(new NormalCometNotifierImpl[notifiers.size()]);
            for (int i = 0; i < array.length; ++i) {
                NormalCometNotifierImpl notifier = array[i];
                notifier.stop();
            }
            notifiers.clear();
        }
        if (this.hasItsNatTimerEventListeners()) {
            ItsNatTimerEventListenerRegistryImpl registry = this.getItsNatTimerEventListenerRegistry();
            registry.removeAllItsNatNormalEventListeners(true);
        }
        if (this.getClientDocumentStfulDelegate() instanceof ClientDocumentStfulDelegateWebImpl && (clientDocDeleg = (ClientDocumentStfulDelegateWebImpl)this.getClientDocumentStfulDelegate()).hasHTMLIFrameFileUploads()) {
            MapUniqueId<HTMLIFrameFileUploadImpl> map = clientDocDeleg.getHTMLIFrameFileUploadMap();
            HTMLIFrameFileUploadImpl[] array = (HTMLIFrameFileUploadImpl[])map.toArray(new HTMLIFrameFileUploadImpl[map.size()]);
            for (int i = 0; i < array.length; ++i) {
                HTMLIFrameFileUploadImpl fileUp = array[i];
                fileUp.dispose();
            }
            map.clear();
        }
    }

    @Override
    public void startEventDispatcherThread(final Runnable task) {
        final ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        if (!Thread.holdsLock(itsNatDoc) || itsNatDoc.getCurrentItsNatServletRequest() == null) {
            throw new ItsNatException("Caller thread must be a normal browser-request thread", (Object)this);
        }
        if (task instanceof Thread) {
            throw new ItsNatException("Runnable object must not be a Thread", (Object)task);
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                itsNatDoc.setEventDispatcherClientDocByThread(ClientDocumentStfulImpl.this);
                try {
                    task.run();
                }
                finally {
                    itsNatDoc.setEventDispatcherClientDocByThread(null);
                    itsNatDoc.unlockThreads();
                }
            }
        };
        thread.start();
        long evtDispMaxWait = itsNatDoc.getEventDispatcherMaxWait();
        itsNatDoc.lockThread(evtDispMaxWait);
    }

    @Override
    public boolean dispatchEvent(EventTarget target, Event evt) throws EventException {
        return this.dispatchEvent(target, evt, this.getCommMode(), this.getEventTimeout());
    }

    @Override
    public boolean dispatchEvent(EventTarget target, Event evt, int commMode, long eventTimeout) throws EventException {
        return this.getClientDocumentStfulDelegate().dispatchEvent(target, evt, commMode, eventTimeout);
    }

    @Override
    public ScriptUtil getScriptUtil() {
        if (this.scriptUtil == null) {
            this.scriptUtil = this.getClientDocumentStfulDelegate().createScriptUtil();
        }
        return this.scriptUtil;
    }
}

