/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.clientdoc;

import java.io.Serializable;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.event.CustomParamTransport;
import org.itsnat.core.event.ItsNatContinueEvent;
import org.itsnat.core.event.ParamTransport;
import org.itsnat.core.script.ScriptUtil;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.droid.BrowserDroid;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.NodeCacheRegistryImpl;
import org.itsnat.impl.core.clientdoc.droid.ClientDocumentStfulDelegateDroidImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.dompath.DOMPathResolver;
import org.itsnat.impl.core.dompath.NodeLocationImpl;
import org.itsnat.impl.core.dompath.NodeLocationWithParentImpl;
import org.itsnat.impl.core.event.EventInternal;
import org.itsnat.impl.core.listener.EventListenerSerializableInternal;
import org.itsnat.impl.core.mut.client.ClientMutationEventListenerStfulImpl;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class ClientDocumentStfulDelegateImpl
implements Serializable {
    protected ClientDocumentStfulImpl clientDoc;
    protected ClientMutationEventListenerStfulImpl mutationListener;
    protected NodeCacheRegistryImpl nodeCache;
    protected DOMPathResolver pathResolver;

    public ClientDocumentStfulDelegateImpl(ClientDocumentStfulImpl clientDoc) {
        this.clientDoc = clientDoc;
        this.mutationListener = ClientMutationEventListenerStfulImpl.createClientMutationEventListenerStful(this);
        this.pathResolver = DOMPathResolver.createDOMPathResolver(this);
        if (clientDoc.getItsNatStfulDocument().isNodeCacheEnabled()) {
            this.nodeCache = new NodeCacheRegistryImpl(this);
        }
    }

    public static ClientDocumentStfulDelegateImpl createClientDocumentStfulDelegate(ClientDocumentStfulImpl clientDoc) {
        Browser browser = clientDoc.getBrowser();
        if (browser instanceof BrowserWeb) {
            return new ClientDocumentStfulDelegateWebImpl(clientDoc);
        }
        if (browser instanceof BrowserDroid) {
            return new ClientDocumentStfulDelegateDroidImpl(clientDoc);
        }
        return null;
    }

    public int getCommMode() {
        return this.clientDoc.getCommMode();
    }

    public long getEventTimeout() {
        return this.clientDoc.getEventTimeout();
    }

    public ClientDocumentStfulImpl getClientDocumentStful() {
        return this.clientDoc;
    }

    public ItsNatStfulDocumentImpl getItsNatStfulDocument() {
        return this.getClientDocumentStful().getItsNatStfulDocument();
    }

    public Browser getBrowser() {
        return this.clientDoc.getBrowser();
    }

    public DOMPathResolver getDOMPathResolver() {
        return this.pathResolver;
    }

    public ClientMutationEventListenerStfulImpl getClientMutationEventListenerStful() {
        return this.mutationListener;
    }

    public boolean isNodeCacheEnabled() {
        return this.nodeCache != null;
    }

    public NodeCacheRegistryImpl getNodeCacheRegistry() {
        return this.nodeCache;
    }

    public void addCodeToSend(Object code) {
        this.clientDoc.addCodeToSend(code);
    }

    public String getCachedNodeId(Node node) {
        NodeCacheRegistryImpl cacheNode = this.getNodeCacheRegistry();
        if (cacheNode == null) {
            return null;
        }
        return cacheNode.getId(node);
    }

    public String removeNodeFromCache(Node node) {
        NodeCacheRegistryImpl cacheNode = this.getNodeCacheRegistry();
        if (cacheNode == null) {
            return null;
        }
        return cacheNode.removeNode(node);
    }

    public Node getNodeFromPath(String pathStr, Node topParent) {
        return this.getDOMPathResolver().getNodeFromPath(pathStr, topParent);
    }

    public String getRelativeStringPathFromNodeParent(Node child) {
        return this.getDOMPathResolver().getRelativeStringPathFromNodeParent(child);
    }

    public String getStringPathFromNode(Node node) {
        return this.getDOMPathResolver().getStringPathFromNode(node);
    }

    public String getStringPathFromNode(Node node, Node topParent) {
        return this.getDOMPathResolver().getStringPathFromNode(node, topParent);
    }

    public Node getNextSiblingInClientDOM(Node node) {
        return this.getDOMPathResolver().getNextSiblingInClientDOM(node);
    }

    public NodeLocationImpl getNodeLocation(Node node, boolean cacheIfPossible) {
        return NodeLocationImpl.getNodeLocation(this, node, cacheIfPossible);
    }

    public NodeLocationImpl getRefNodeLocationInsertBefore(Node newNode, Node nextSibling) {
        return NodeLocationImpl.getRefNodeLocationInsertBefore(this, newNode, nextSibling);
    }

    public String removeNodeFromCacheAndSendCode(Node node) {
        String oldId = this.removeNodeFromCache(node);
        if (oldId == null) {
            return null;
        }
        this.addCodeToSend(this.renderRemoveNodeFromCache(oldId));
        return oldId;
    }

    public Node getNodeFromStringPathFromClient(String pathStr, boolean cacheIfPossible) {
        Node node;
        Node parent;
        String path;
        String parentId;
        if (pathStr.equals("null")) {
            return null;
        }
        NodeCacheRegistryImpl nodeCache = this.getNodeCacheRegistry();
        if (pathStr.startsWith("id:")) {
            String id = pathStr.substring("id:".length());
            return nodeCache.getNodeById(id);
        }
        if (pathStr.startsWith("pid:")) {
            int posSepPath = pathStr.lastIndexOf(58);
            parentId = pathStr.substring("pid:".length(), posSepPath);
            path = pathStr.substring(posSepPath + 1);
            parent = nodeCache.getNodeById(parentId);
            if (parent == null) {
                throw new ItsNatException("INTERNAL ERROR");
            }
        } else {
            path = pathStr;
            parent = null;
            parentId = null;
        }
        if ((node = this.getNodeFromPath(path, parent)) == null) {
            return null;
        }
        if (cacheIfPossible && nodeCache != null) {
            String id = nodeCache.getId(node);
            if (id != null) {
                return node;
            }
            id = nodeCache.addNode(node);
            if (id != null) {
                NodeLocationWithParentImpl nodeLoc = NodeLocationWithParentImpl.getNodeLocationWithParent(node, id, path, parent, parentId, true, this);
                this.addCodeToSend(this.renderAddNodeToCache(nodeLoc));
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchEvent(EventTarget target, Event evt, int commMode, long eventTimeout) throws EventException {
        final ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        if (Thread.holdsLock(itsNatDoc)) {
            throw new ItsNatException("Document must be unlocked in this call", (Object)this);
        }
        if (this.getClientDocumentStful() != itsNatDoc.getEventDispatcherClientDocByThread()) {
            throw new ItsNatException("This thread is not an event dispatcher thread");
        }
        ((EventInternal)evt).checkInitializedEvent();
        ((EventInternal)evt).setTarget(target);
        final long evtDispMaxWait = itsNatDoc.getEventDispatcherMaxWait();
        final boolean[] monitor = new boolean[1];
        Object object = itsNatDoc;
        synchronized (object) {
            this.clientDoc.addCodeToSend(this.getCodeDispatchEvent(target, evt, "res", this));
            EventListenerSerializableInternal listener = new EventListenerSerializableInternal(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleEvent(Event evt) {
                    ItsNatContinueEvent contEvt = (ItsNatContinueEvent)evt;
                    monitor[0] = Boolean.getBoolean((String)contEvt.getExtraParam("itsnat_res"));
                    boolean[] blArray = monitor;
                    synchronized (monitor) {
                        monitor.notifyAll();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        itsNatDoc.lockThread(evtDispMaxWait);
                        return;
                    }
                }
            };
            CustomParamTransport param = new CustomParamTransport("itsnat_res", "res");
            this.getClientDocumentStful().addContinueEventListener(null, listener, commMode, new ParamTransport[]{param}, null, eventTimeout);
            itsNatDoc.notifyAll();
        }
        object = monitor;
        synchronized (monitor) {
            try {
                monitor.wait(evtDispMaxWait);
            }
            catch (InterruptedException ex) {
                throw new ItsNatException(ex, (Object)this);
            }
            return monitor[0];
        }
    }

    public abstract void addPlatformEventListener(EventTarget var1, String var2, EventListener var3, boolean var4, int var5, ParamTransport[] var6, String var7, long var8, String var10);

    public abstract void removePlatformEventListener(EventTarget var1, String var2, EventListener var3, boolean var4, boolean var5);

    public abstract int removeAllPlatformEventListeners(EventTarget var1, boolean var2);

    public abstract void addMutationEventListener(EventTarget var1, EventListener var2, boolean var3);

    public abstract void addMutationEventListener(EventTarget var1, EventListener var2, boolean var3, int var4, String var5, long var6, String var8);

    public abstract void removeMutationEventListener(EventTarget var1, EventListener var2, boolean var3);

    public abstract ScriptUtil createScriptUtil();

    protected abstract String getCodeDispatchEvent(EventTarget var1, Event var2, String var3, ClientDocumentStfulDelegateImpl var4);

    public abstract String getNodeReference(Node var1, boolean var2, boolean var3);

    protected abstract String renderAddNodeToCache(NodeLocationWithParentImpl var1);

    protected abstract String renderRemoveNodeFromCache(String var1);
}

