/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.clientdoc;

import java.util.LinkedList;
import org.itsnat.core.ClientDocument;
import org.itsnat.core.ItsNatDocument;
import org.itsnat.core.ItsNatSession;
import org.itsnat.core.event.ParamTransport;
import org.itsnat.impl.core.ItsNatUserDataImpl;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.itsnat.impl.core.util.HasUniqueId;
import org.itsnat.impl.core.util.UniqueId;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class ClientDocumentImpl
extends ItsNatUserDataImpl
implements ClientDocument,
HasUniqueId {
    protected UniqueId idObj;
    protected ItsNatSessionImpl session;
    protected long creationTime = System.currentTimeMillis();
    protected boolean invalid = false;
    protected long lastEventTime = this.creationTime;
    protected Browser browser;

    public ClientDocumentImpl(Browser browser, ItsNatSessionImpl session) {
        super(false);
        this.idObj = session.getUniqueIdGenerator().generateUniqueId("cd");
        this.session = session;
        this.browser = browser;
    }

    public abstract boolean isScriptingEnabled();

    public Browser getBrowser() {
        return this.browser;
    }

    @Override
    public ItsNatSession getItsNatSession() {
        return this.session;
    }

    public ItsNatSessionImpl getItsNatSessionImpl() {
        return this.session;
    }

    @Override
    public String getId() {
        return this.idObj.getId();
    }

    @Override
    public UniqueId getUniqueId() {
        return this.idObj;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setInvalid() {
        if (this.invalid) {
            return;
        }
        this.setInvalidInternal();
    }

    protected void setInvalidInternal() {
        this.invalid = true;
    }

    public abstract ItsNatDocumentImpl getItsNatDocumentImpl();

    @Override
    public ItsNatDocument getItsNatDocument() {
        return this.getItsNatDocumentImpl();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastRequestTime() {
        return this.lastEventTime;
    }

    public abstract String getCodeToSendAndReset();

    public abstract void registerInSession();

    public abstract void addMutationEventListener(EventTarget var1, EventListener var2, boolean var3, int var4, String var5, long var6, String var8);

    public abstract void addEventListener(EventTarget var1, String var2, EventListener var3, boolean var4, int var5, ParamTransport[] var6, String var7, long var8, String var10);

    public abstract void addUserEventListener(EventTarget var1, String var2, EventListener var3, int var4, ParamTransport[] var5, String var6, long var7, String var9);

    public abstract void removeEventListener(EventTarget var1, String var2, EventListener var3, boolean var4, boolean var5);

    public abstract boolean hasGlobalEventListenerListeners();

    public abstract void getGlobalEventListenerList(LinkedList<EventListener> var1);
}

