/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.clientdoc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.itsnat.core.ItsNatServletRequest;
import org.itsnat.core.ItsNatServletResponse;
import org.itsnat.impl.core.browser.web.BrowserGecko;
import org.itsnat.impl.core.clientdoc.ClientDocumentWithoutDocumentImpl;
import org.itsnat.impl.core.servlet.DeserialPendingTask;
import org.itsnat.impl.core.servlet.ItsNatServletImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionObjectInputStream;
import org.itsnat.impl.core.template.ItsNatStfulDocumentTemplateAttachedServerImpl;
import org.itsnat.impl.core.template.MarkupTemplateImpl;

public abstract class ClientDocumentAttachedServerImpl
extends ClientDocumentWithoutDocumentImpl {
    protected transient ItsNatStfulDocumentTemplateAttachedServerImpl docTemplate;
    protected StringBuilder clientMarkup = new StringBuilder();

    public ClientDocumentAttachedServerImpl(ItsNatSessionImpl session, ItsNatStfulDocumentTemplateAttachedServerImpl docTemplate) {
        super(session);
        this.docTemplate = docTemplate;
    }

    public ItsNatStfulDocumentTemplateAttachedServerImpl getItsNatStfulDocumentTemplateAttachedServer() {
        return this.docTemplate;
    }

    @Override
    protected void setInvalidInternal() {
        super.setInvalidInternal();
        this.session.removeClientDocumentAttachedServer(this);
    }

    @Override
    public void registerInSession() {
        this.session.addClientDocumentAttachedServer(this);
    }

    public void addClientMarkup(String markup) {
        this.clientMarkup.append(markup);
    }

    public String getClientMarkup() {
        String res = this.clientMarkup.toString();
        if (this.getBrowser() instanceof BrowserGecko) {
            int pos = res.indexOf("$%7B");
            while (pos != -1) {
                int pos2 = (res = res.substring(0, pos) + "${" + res.substring(pos + 4)).indexOf("%7D", pos);
                if (pos2 != -1) {
                    res = res.substring(0, pos2) + "}" + res.substring(pos2 + 3);
                }
                pos = res.indexOf("$%7B", pos);
            }
        }
        this.clientMarkup = null;
        return res;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ItsNatServletImpl itsNatServlet = this.docTemplate.getItsNatServletImpl();
        ItsNatServletImpl.writeObject(itsNatServlet, out);
        MarkupTemplateImpl.writeObject(this.docTemplate, out);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String servletName = ItsNatServletImpl.readObject(in);
        final String[] templateVerId = MarkupTemplateImpl.readObject(in);
        in.defaultReadObject();
        DeserialPendingTask task = new DeserialPendingTask(){

            @Override
            public void process(ItsNatServletImpl itsNatServlet, ItsNatServletRequest request, ItsNatServletResponse response) {
                ClientDocumentAttachedServerImpl.this.docTemplate = (ItsNatStfulDocumentTemplateAttachedServerImpl)MarkupTemplateImpl.getMarkupTemplate(itsNatServlet, templateVerId);
            }
        };
        ItsNatSessionImpl itsNatSession = ItsNatSessionObjectInputStream.getItsNatSession(in);
        itsNatSession.addDeserialPendingTask(servletName, task);
    }

    public abstract boolean isOnLoadHanderUsed();
}

