/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.clientdoc;

import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.clientdoc.web.SVGWebInfoImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.listener.WaitForEventListenerImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.w3c.dom.events.EventListener;

public abstract class ClientDocumentAttachedClientImpl
extends ClientDocumentStfulImpl {
    protected boolean readOnly;
    protected int commMode;
    protected long eventTimeout;
    protected long waitDocTimeout;
    protected int phase = 1;
    protected boolean accepted = false;

    public ClientDocumentAttachedClientImpl(boolean readOnly, int commMode, long eventTimeout, long waitDocTimeout, Browser browser, ItsNatSessionImpl itsNatSession, ItsNatStfulDocumentImpl itsNatDoc) {
        super(itsNatDoc, browser, itsNatSession);
        this.readOnly = readOnly;
        this.commMode = commMode;
        this.eventTimeout = eventTimeout;
        this.waitDocTimeout = waitDocTimeout;
    }

    public abstract String getAttachType();

    @Override
    public void registerInSession() {
        this.getItsNatSessionImpl().registerClientDocumentAttachedClient(this);
    }

    @Override
    public boolean isScriptingEnabled() {
        return true;
    }

    @Override
    public boolean isEventsEnabled() {
        return true;
    }

    @Override
    public boolean canReceiveALLNormalEvents() {
        return !this.isReadOnly();
    }

    @Override
    public boolean canReceiveSOMENormalEvents() {
        if (this.canReceiveALLNormalEvents()) {
            return true;
        }
        if (this.getClientDocumentStfulDelegate() instanceof ClientDocumentStfulDelegateWebImpl) {
            return SVGWebInfoImpl.isSVGWebEnabled((ClientDocumentStfulDelegateWebImpl)this.getClientDocumentStfulDelegate());
        }
        return false;
    }

    @Override
    public boolean canReceiveNormalEvents(EventListener listener) {
        if (this.canReceiveALLNormalEvents()) {
            return true;
        }
        if (this.getClientDocumentStfulDelegate() instanceof ClientDocumentStfulDelegateWebImpl && !SVGWebInfoImpl.isSVGWebEnabled((ClientDocumentStfulDelegateWebImpl)this.getClientDocumentStfulDelegate())) {
            return false;
        }
        return listener instanceof WaitForEventListenerImpl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int getCommModeDeclared() {
        return this.commMode;
    }

    @Override
    public long getEventTimeout() {
        return this.eventTimeout;
    }

    public long getWaitDocTimeout() {
        return this.waitDocTimeout;
    }

    public abstract void startAttachedClient();

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        if (this.phase == 4 && this.phase != phase) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        this.phase = phase;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        if (!accepted) {
            this.setInvalid();
        }
        this.accepted = accepted;
    }

    public void attachedClientEventReceived() {
        this.lastEventTime = System.currentTimeMillis();
    }

    @Override
    protected void setInvalidInternal() {
        super.setInvalidInternal();
    }

    public void invalidateAndUnregister() {
        this.getItsNatSessionImpl().unregisterClientDocumentAttachedClient(this);
    }

    public abstract String getRefreshMethod();
}

