/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.browser.web.webkit;

import java.util.HashMap;
import java.util.Map;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKit;
import org.w3c.dom.html.HTMLElement;

public class BrowserWebKitAndroid
extends BrowserWebKit {
    protected int mainVersion;
    private static final Map<String, String[]> tagNamesIgnoreZIndex = new HashMap<String, String[]>();

    public BrowserWebKitAndroid(String userAgent) {
        super(userAgent, 3);
        try {
            int start = userAgent.indexOf("Android ");
            int end = start += "Android ".length();
            int dot = -1;
            while (true) {
                char c;
                if ((c = userAgent.charAt(end)) == '.') {
                    dot = end;
                } else if (c == ';') break;
                ++end;
            }
            this.mainVersion = Integer.parseInt(userAgent.substring(start, dot));
        }
        catch (Exception ex) {
            this.mainVersion = 4;
        }
    }

    @Override
    public boolean isMobile() {
        return true;
    }

    @Override
    public boolean hasBeforeUnloadSupportHTML() {
        return true;
    }

    @Override
    public boolean isFocusOrBlurMethodWrong(String methodName, HTMLElement formElem) {
        return false;
    }

    @Override
    public Map<String, String[]> getHTMLFormControlsIgnoreZIndex() {
        return tagNamesIgnoreZIndex;
    }

    static {
        tagNamesIgnoreZIndex.put("select", null);
        tagNamesIgnoreZIndex.put("input", new String[]{"text", "password", "file", "checkbox", "radio", "button"});
        tagNamesIgnoreZIndex.put("textarea", null);
        tagNamesIgnoreZIndex.put("button", null);
    }
}

