/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.browser.web.webkit;

import org.itsnat.impl.core.browser.web.BrowserW3C;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKitAndroid;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKitChrome;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKitIOS;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKitOpera;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKitSafariDesktop;
import org.itsnat.impl.core.domutil.DOMUtilHTML;
import org.itsnat.impl.core.scriptren.jsren.node.html.JSRenderHTMLElementImpl;
import org.itsnat.impl.core.scriptren.jsren.node.html.w3c.JSRenderHTMLElementWebKitImpl;
import org.w3c.dom.html.HTMLElement;

public abstract class BrowserWebKit
extends BrowserW3C {
    protected static final int SAFARIDESKTOP = 1;
    protected static final int IPHONE = 2;
    protected static final int ANDROID = 3;
    protected static final int GCHROME = 7;
    protected static final int OPERA = 13;
    protected int webKitVersion;

    public BrowserWebKit(String userAgent, int browserSubType) {
        super(userAgent);
        this.browserType = 3;
        this.browserSubType = browserSubType;
        try {
            char c;
            int start = userAgent.indexOf("WebKit/");
            int end = start += "WebKit/".length();
            while ((c = userAgent.charAt(end)) != '.' && c != '+' && c != ' ') {
                ++end;
            }
            String strVer = userAgent.substring(start, end);
            this.webKitVersion = Integer.parseInt(strVer);
        }
        catch (Exception ex) {
            this.webKitVersion = 0;
        }
    }

    public static BrowserWebKit createBrowserWebKit(String userAgent) {
        if (userAgent.contains("OPR/")) {
            return new BrowserWebKitOpera(userAgent);
        }
        if (userAgent.contains("Chrome")) {
            return new BrowserWebKitChrome(userAgent);
        }
        if (userAgent.contains("Android")) {
            return new BrowserWebKitAndroid(userAgent);
        }
        if (userAgent.contains("iPod") || userAgent.contains("iPhone") || userAgent.contains("iPad")) {
            return new BrowserWebKitIOS(userAgent);
        }
        if (userAgent.contains("Mac OS X")) {
            return new BrowserWebKitSafariDesktop(userAgent);
        }
        return new BrowserWebKitSafariDesktop(userAgent);
    }

    public static boolean isWebKit(String userAgent) {
        return userAgent.contains("WebKit");
    }

    @Override
    public boolean isReferrerReferenceStrong() {
        return false;
    }

    @Override
    public boolean isCachedBackForward() {
        return false;
    }

    @Override
    public boolean isCachedBackForwardExecutedScripts() {
        return false;
    }

    @Override
    public boolean isDOMContentLoadedSupported() {
        return true;
    }

    public boolean isAJAXEmptyResponseFails() {
        return false;
    }

    @Override
    public boolean isTextAddedToInsertedSVGScriptNotExecuted() {
        return this.isInsertedSVGScriptNotExecuted();
    }

    @Override
    public boolean canNativelyRenderOtherNSInXHTMLDoc() {
        return true;
    }

    @Override
    public boolean isInsertedSVGScriptNotExecuted() {
        return false;
    }

    public boolean isChangeEventNotFiredUseBlur(HTMLElement formElem) {
        return DOMUtilHTML.isHTMLInputTextBox(formElem);
    }

    @Override
    public JSRenderHTMLElementImpl getJSRenderHTMLElementSingleton() {
        return BrowserWebKit.getJSRenderHTMLElementSingletonStatic();
    }

    public static JSRenderHTMLElementImpl getJSRenderHTMLElementSingletonStatic() {
        return JSRenderHTMLElementWebKitImpl.SINGLETON;
    }
}

