/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.browser.web;

import java.util.Map;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.web.BrowserBatik;
import org.itsnat.impl.core.browser.web.BrowserGecko;
import org.itsnat.impl.core.browser.web.BrowserMSIE9Up;
import org.itsnat.impl.core.browser.web.BrowserMSIEOld;
import org.itsnat.impl.core.browser.web.BrowserUnknown;
import org.itsnat.impl.core.browser.web.opera.BrowserOperaOld;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKit;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.doc.web.ItsNatHTMLDocumentImpl;
import org.itsnat.impl.core.scriptren.jsren.node.html.JSRenderHTMLAttributeImpl;
import org.itsnat.impl.core.scriptren.jsren.node.html.JSRenderHTMLElementImpl;
import org.itsnat.impl.core.scriptren.jsren.node.html.JSRenderHTMLTextImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.w3c.dom.html.HTMLElement;

public abstract class BrowserWeb
extends Browser {
    public static final int UNKNOWN = 0;
    public static final int MSIE_OLD = 1;
    public static final int GECKO = 2;
    public static final int WEBKIT = 3;
    public static final int OPERA_OLD = 4;
    public static final int BLACKBERRY_OLD = 5;
    public static final int ADOBE_SVG = 6;
    public static final int BATIK = 7;
    public static final int MSIE_9 = 8;
    protected int browserType;
    protected int browserSubType = -1;
    protected transient JSRenderHTMLElementImpl jsRenderHtmlElement;
    protected transient JSRenderHTMLTextImpl jsRenderHtmlText;
    protected transient JSRenderHTMLAttributeImpl jsRenderHtmlAttr;

    public BrowserWeb(String userAgent) {
        super(userAgent);
    }

    public static BrowserWeb createBrowserWeb(String userAgent, ItsNatServletRequestImpl itsNatRequest) {
        if (BrowserWeb.isMSIE(userAgent, itsNatRequest)) {
            int version = BrowserWeb.getMSIEVersion(userAgent);
            if (version <= 8) {
                return BrowserMSIEOld.createBrowserMSIEOld(userAgent, itsNatRequest, version);
            }
            return new BrowserMSIE9Up(userAgent, version);
        }
        if (BrowserGecko.isGecko(userAgent, itsNatRequest)) {
            return BrowserGecko.createBrowserGecko(userAgent, itsNatRequest);
        }
        if (BrowserWebKit.isWebKit(userAgent)) {
            return BrowserWebKit.createBrowserWebKit(userAgent);
        }
        if (BrowserOperaOld.isOperaOld(userAgent, itsNatRequest)) {
            return BrowserOperaOld.createBrowserOperaOld(userAgent);
        }
        if (BrowserBatik.isBatik(userAgent)) {
            return new BrowserBatik(userAgent);
        }
        return new BrowserUnknown(userAgent);
    }

    public static boolean isMSIE(String userAgent, ItsNatServletRequestImpl itsNatRequest) {
        return userAgent.contains("MSIE") && !BrowserOperaOld.isOperaOld(userAgent, itsNatRequest) || userAgent.contains("Trident") || userAgent.contains("Edge");
    }

    public static int getMSIEVersion(String userAgent) {
        if (userAgent.contains("MSIE ")) {
            try {
                int start = userAgent.indexOf("MSIE ") + "MSIE ".length();
                int end = userAgent.indexOf(46, start);
                return Integer.parseInt(userAgent.substring(start, end));
            }
            catch (Exception ex) {
                return 8;
            }
        }
        if (userAgent.contains("Trident")) {
            try {
                int start = userAgent.indexOf("rv:") + "rv:".length();
                int end = userAgent.indexOf(46, start);
                return Integer.parseInt(userAgent.substring(start, end));
            }
            catch (Exception ex) {
                return 8;
            }
        }
        if (userAgent.contains("Edge")) {
            try {
                int start = userAgent.indexOf("Edge/") + "Edge/".length();
                int end = userAgent.indexOf(46, start);
                return Integer.parseInt(userAgent.substring(start, end));
            }
            catch (Exception ex) {
                return 8;
            }
        }
        return 8;
    }

    public int getTypeCode() {
        return this.browserType;
    }

    public int getSubTypeCode() {
        return this.browserSubType;
    }

    public abstract boolean isMobile();

    public JSRenderHTMLElementImpl getJSRenderHTMLElement() {
        return this.jsRenderHtmlElement;
    }

    public void setJSRenderHTMLElement(JSRenderHTMLElementImpl jsRenderHtmlElement) {
        this.jsRenderHtmlElement = jsRenderHtmlElement;
    }

    public JSRenderHTMLTextImpl getJSRenderHTMLText() {
        return this.jsRenderHtmlText;
    }

    public void setJSRenderHTMLText(JSRenderHTMLTextImpl jsRenderHtmlText) {
        this.jsRenderHtmlText = jsRenderHtmlText;
    }

    public JSRenderHTMLAttributeImpl getJSRenderHTMLAttribute() {
        return this.jsRenderHtmlAttr;
    }

    public void setJSRenderHTMLAttribute(JSRenderHTMLAttributeImpl jsRenderHtmlAttr) {
        this.jsRenderHtmlAttr = jsRenderHtmlAttr;
    }

    public boolean hasBeforeUnloadSupport(ItsNatStfulDocumentImpl itsNatDoc) {
        if (itsNatDoc instanceof ItsNatHTMLDocumentImpl) {
            return this.hasBeforeUnloadSupportHTML();
        }
        return false;
    }

    public abstract boolean hasBeforeUnloadSupportHTML();

    public abstract boolean isDOMContentLoadedSupported();

    public abstract boolean isCachedBackForwardExecutedScripts();

    public abstract boolean isCachedBackForward();

    public abstract boolean isFocusOrBlurMethodWrong(String var1, HTMLElement var2);

    public abstract Map<String, String[]> getHTMLFormControlsIgnoreZIndex();

    public abstract boolean canNativelyRenderOtherNSInXHTMLDoc();

    public abstract boolean isInsertedSVGScriptNotExecuted();

    public abstract boolean isTextAddedToInsertedSVGScriptNotExecuted();

    public abstract JSRenderHTMLElementImpl getJSRenderHTMLElementSingleton();
}

