/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.browser.web;

import java.util.HashMap;
import java.util.Map;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.domutil.DOMUtilHTML;
import org.itsnat.impl.core.scriptren.jsren.node.html.JSRenderHTMLElementImpl;
import org.itsnat.impl.core.scriptren.jsren.node.html.msie.JSRenderHTMLElementMSIEOldImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.w3c.dom.html.HTMLElement;

public class BrowserMSIEOld
extends BrowserWeb {
    public static final int MSIE_DESKTOP = 1;
    public static final int MSIE_MOBILE = 2;
    private static final Map<String, String[]> tagNamesIgnoreZIndex = new HashMap<String, String[]>();
    protected int version;

    public BrowserMSIEOld(String userAgent, int version, boolean mobile) {
        super(userAgent);
        this.browserType = 1;
        this.browserSubType = mobile ? 2 : 1;
        this.version = version;
    }

    public static BrowserMSIEOld createBrowserMSIEOld(String userAgent, ItsNatServletRequestImpl itsNatRequest, int version) {
        if (userAgent.contains("MSIEMobile")) {
            return new BrowserMSIEOld(userAgent, version, true);
        }
        String os = itsNatRequest.getHeader("UA-OS");
        boolean mobile = os != null && os.contains("Windows CE");
        return new BrowserMSIEOld(userAgent, version, mobile);
    }

    @Override
    public boolean isMobile() {
        return this.browserSubType == 2;
    }

    @Override
    public boolean canNativelyRenderOtherNSInXHTMLDoc() {
        return false;
    }

    @Override
    public boolean isInsertedSVGScriptNotExecuted() {
        return false;
    }

    @Override
    public boolean isTextAddedToInsertedSVGScriptNotExecuted() {
        return false;
    }

    @Override
    public boolean hasBeforeUnloadSupportHTML() {
        return true;
    }

    @Override
    public boolean isReferrerReferenceStrong() {
        return true;
    }

    @Override
    public boolean isCachedBackForward() {
        return false;
    }

    @Override
    public boolean isCachedBackForwardExecutedScripts() {
        return false;
    }

    @Override
    public boolean isDOMContentLoadedSupported() {
        return false;
    }

    @Override
    public boolean isFocusOrBlurMethodWrong(String methodName, HTMLElement formElem) {
        return DOMUtilHTML.isHTMLTextAreaOrInputTextBox(formElem);
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public Map<String, String[]> getHTMLFormControlsIgnoreZIndex() {
        if (this.version < 7) {
            return tagNamesIgnoreZIndex;
        }
        return null;
    }

    @Override
    public JSRenderHTMLElementImpl getJSRenderHTMLElementSingleton() {
        return BrowserMSIEOld.getJSRenderHTMLElementSingletonStatic();
    }

    public static JSRenderHTMLElementImpl getJSRenderHTMLElementSingletonStatic() {
        return JSRenderHTMLElementMSIEOldImpl.SINGLETON;
    }

    static {
        tagNamesIgnoreZIndex.put("select", null);
    }
}

