/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.browser.web;

import java.util.Map;
import org.itsnat.impl.core.browser.web.BrowserW3C;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKit;
import org.itsnat.impl.core.scriptren.jsren.node.html.JSRenderHTMLElementImpl;
import org.itsnat.impl.core.scriptren.jsren.node.html.w3c.JSRenderHTMLElementGeckoImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.w3c.dom.html.HTMLElement;

public class BrowserGecko
extends BrowserW3C {
    protected float geckoVersion;

    public BrowserGecko(String userAgent, ItsNatServletRequestImpl itsNatRequest) {
        super(userAgent);
        this.browserType = 2;
        try {
            int start = userAgent.indexOf("rv:");
            int end = (start += "rv:".length()) + 3;
            String strVer = userAgent.substring(start, end);
            this.geckoVersion = Float.parseFloat(strVer);
        }
        catch (Exception ex) {
            this.geckoVersion = 0.0f;
        }
    }

    public static BrowserGecko createBrowserGecko(String userAgent, ItsNatServletRequestImpl itsNatRequest) {
        return new BrowserGecko(userAgent, itsNatRequest);
    }

    public static boolean isGecko(String userAgent, ItsNatServletRequestImpl itsNatRequest) {
        return userAgent.contains("Gecko") && !BrowserWebKit.isWebKit(userAgent);
    }

    @Override
    public boolean isMobile() {
        return false;
    }

    @Override
    public boolean hasBeforeUnloadSupportHTML() {
        return true;
    }

    @Override
    public boolean isInsertedSVGScriptNotExecuted() {
        return false;
    }

    @Override
    public boolean isTextAddedToInsertedSVGScriptNotExecuted() {
        return false;
    }

    @Override
    public boolean canNativelyRenderOtherNSInXHTMLDoc() {
        return true;
    }

    @Override
    public boolean isReferrerReferenceStrong() {
        return false;
    }

    @Override
    public boolean isCachedBackForward() {
        return false;
    }

    @Override
    public boolean isCachedBackForwardExecutedScripts() {
        return false;
    }

    @Override
    public boolean isDOMContentLoadedSupported() {
        return true;
    }

    @Override
    public boolean isFocusOrBlurMethodWrong(String methodName, HTMLElement formElem) {
        return false;
    }

    @Override
    public Map<String, String[]> getHTMLFormControlsIgnoreZIndex() {
        return null;
    }

    @Override
    public JSRenderHTMLElementImpl getJSRenderHTMLElementSingleton() {
        return BrowserGecko.getJSRenderHTMLElementSingletonStatic();
    }

    public static JSRenderHTMLElementImpl getJSRenderHTMLElementSingletonStatic() {
        return JSRenderHTMLElementGeckoImpl.SINGLETON;
    }
}

