/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.browser;

import java.io.Serializable;
import org.itsnat.impl.core.browser.droid.BrowserDroid;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;

public abstract class Browser
implements Serializable {
    protected String userAgent;

    public Browser(String userAgent) {
        this.userAgent = userAgent;
    }

    public static Browser createBrowser(ItsNatServletRequestImpl itsNatRequest) {
        String userAgent = itsNatRequest.getHeader("User-Agent");
        if (BrowserDroid.isBrowserDroid(userAgent)) {
            return new BrowserDroid(userAgent);
        }
        return BrowserWeb.createBrowserWeb(userAgent, itsNatRequest);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public abstract boolean isReferrerReferenceStrong();

    public boolean isNeededAbsoluteURL() {
        return false;
    }
}

