/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core;

import java.io.Serializable;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.markup.render.DOMRenderImpl;
import org.itsnat.impl.core.servlet.ItsNatServletImpl;
import org.itsnat.impl.core.template.CachedSubtreeImpl;
import org.itsnat.impl.core.template.MarkupTemplateVersionImpl;
import org.itsnat.impl.core.util.MapUniqueId;
import org.itsnat.impl.core.util.UniqueId;
import org.itsnat.impl.core.util.UniqueIdGenIntList;
import org.w3c.dom.Document;

public abstract class MarkupContainerImpl
implements Serializable {
    protected transient MapUniqueId<MarkupTemplateVersionImpl> usedTemplatesWithCachedNodes;
    protected UniqueIdGenIntList idGenerator = new UniqueIdGenIntList(false);
    protected UniqueId idObj;

    public MarkupContainerImpl(UniqueIdGenIntList idGenerator) {
        this.idObj = idGenerator.generateUniqueId(this.getIdGenPrefix());
    }

    public abstract ItsNatServletImpl getItsNatServlet();

    public abstract String getIdGenPrefix();

    public UniqueIdGenIntList getUniqueIdGenerator() {
        return this.idGenerator;
    }

    public abstract Document getDocument();

    public abstract boolean hasCachedNodes();

    public MapUniqueId<MarkupTemplateVersionImpl> getUsedTemplateVersionsWithCachedNodes() {
        if (this.usedTemplatesWithCachedNodes == null) {
            ItsNatServletImpl itsNatServlet = this.getItsNatServlet();
            this.usedTemplatesWithCachedNodes = this.createUsedTemplateVersionsWithCachedNodesMap(itsNatServlet);
        }
        return this.usedTemplatesWithCachedNodes;
    }

    protected MapUniqueId<MarkupTemplateVersionImpl> createUsedTemplateVersionsWithCachedNodesMap(ItsNatServletImpl itsNatServlet) {
        return new MapUniqueId<MarkupTemplateVersionImpl>(itsNatServlet.getUniqueIdGenerator());
    }

    public MarkupTemplateVersionImpl getUsedMarkupTemplateVersion(String id) {
        return this.getUsedTemplateVersionsWithCachedNodes().get(id);
    }

    public void addUsedMarkupTemplateVersionWithCachedNodes(MarkupTemplateVersionImpl template) {
        if (!template.hasCachedNodes()) {
            return;
        }
        MapUniqueId<MarkupTemplateVersionImpl> usedTemplates = this.getUsedTemplateVersionsWithCachedNodes();
        if (usedTemplates.containsKey(template)) {
            return;
        }
        usedTemplates.put(template);
        MapUniqueId<MarkupTemplateVersionImpl> templatesOfTemplate = template.getUsedTemplateVersionsWithCachedNodes();
        usedTemplates.putAll(templatesOfTemplate);
    }

    public String resolveCachedNodes(String text, boolean resolveEntities) {
        if (this.hasCachedNodes()) {
            int start = text.indexOf(CachedSubtreeImpl.getMarkCodeStart());
            if (start == -1) {
                return text;
            }
            StringBuilder textRes = new StringBuilder();
            while (start != -1) {
                int end = text.indexOf(125, start);
                if (end == -1) {
                    throw new ItsNatException("INTERNAL ERROR");
                }
                String mark = text.substring(start, ++end);
                String templateId = CachedSubtreeImpl.getTemplateId(mark);
                MarkupTemplateVersionImpl template = this.getUsedMarkupTemplateVersion(templateId);
                MapUniqueId<CachedSubtreeImpl> cacheMap = template.getElementCacheMap();
                String nodeId = CachedSubtreeImpl.getNodeId(mark);
                CachedSubtreeImpl cachedNode = cacheMap.get(nodeId);
                textRes.append(text.substring(0, start));
                String cachedCode = cachedNode.getCode(resolveEntities);
                cachedCode = this.resolveCachedNodes(cachedCode, resolveEntities);
                textRes.append(cachedCode);
                text = text.substring(start + mark.length());
                start = text.indexOf(CachedSubtreeImpl.getMarkCodeStart());
            }
            textRes.append(text);
            text = textRes.toString();
        }
        return text;
    }

    protected String serializeDocument(Document doc, DOMRenderImpl docRender, boolean resolveCachedNodes) {
        String text = docRender.serializeDocument(doc);
        if (resolveCachedNodes) {
            text = this.resolveCachedNodes(text, false);
        }
        return text;
    }
}

