/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatVariableResolver;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.servlet.ItsNatServletContextImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ItsNatVariableResolverImpl
implements ItsNatVariableResolver {
    protected ItsNatVariableResolverImpl parentResolver;
    protected ItsNatServletRequestImpl request;
    protected ItsNatDocumentImpl itsNatDoc;
    protected ItsNatSessionImpl session;
    protected ItsNatServletContextImpl context;
    protected Map<String, Object> localAttribs = new HashMap<String, Object>();

    public ItsNatVariableResolverImpl(ItsNatVariableResolverImpl parent, ItsNatServletRequestImpl request, ItsNatDocumentImpl itsNatDoc, ItsNatSessionImpl session, ItsNatServletContextImpl context) {
        this.parentResolver = parent;
        this.request = request;
        this.itsNatDoc = itsNatDoc;
        this.session = session;
        this.context = context;
    }

    @Override
    public ItsNatVariableResolver createItsNatVariableResolver() {
        return new ItsNatVariableResolverImpl(this, null, null, null, null);
    }

    @Override
    public Object getLocalVariable(String name) {
        return this.localAttribs.get(name);
    }

    @Override
    public Object setLocalVariable(String name, Object value) {
        return this.localAttribs.put(name, value);
    }

    @Override
    public Object removeLocalVariable(String name) {
        return this.localAttribs.remove(name);
    }

    @Override
    public void introspect(String refName, Object obj) {
        BeanInfo beanInfo;
        String prefix = "";
        if (refName != null && !refName.equals("")) {
            prefix = refName + ".";
        }
        Class<?> clasz = obj.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(clasz);
        }
        catch (IntrospectionException ex) {
            throw new ItsNatException(ex, (Object)this);
        }
        PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
        try {
            for (int i = 0; i < props.length; ++i) {
                PropertyDescriptor property = props[i];
                String propName = property.getName();
                Method method = property.getReadMethod();
                Object res = method.invoke(obj, (Object[])null);
                this.setLocalVariable(prefix + propName, res);
            }
        }
        catch (IllegalAccessException ex) {
            throw new ItsNatException(ex, (Object)this);
        }
        catch (InvocationTargetException ex) {
            throw new ItsNatException(ex, (Object)this);
        }
    }

    @Override
    public boolean isDisconnected() {
        return this.parentResolver == null && this.request == null && this.itsNatDoc == null && this.session == null && this.context == null;
    }

    @Override
    public Object getVariable(String name) {
        Object value = this.getLocalVariable(name);
        if (value != null) {
            return value;
        }
        if (this.parentResolver != null) {
            return this.parentResolver.getVariable(name);
        }
        if (this.request != null) {
            return this.request.getVariable(name);
        }
        if (this.itsNatDoc != null) {
            return this.itsNatDoc.getVariable(name);
        }
        if (this.session != null) {
            return this.session.getVariable(name);
        }
        if (this.context != null) {
            return this.context.getVariable(name);
        }
        return null;
    }

    @Override
    public String resolve(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return null;
        }
        boolean resolvedSomeVar = false;
        StringBuilder res = new StringBuilder();
        int pos = 0;
        do {
            int first;
            if ((first = str.indexOf("${", pos)) != -1) {
                int end = str.indexOf(125, first + 2);
                if (end != -1) {
                    res.append(str.substring(pos, first));
                    String varName = str.substring(first + 2, end);
                    Object value = this.getVariable(varName);
                    if (value != null) {
                        res.append(value.toString());
                        resolvedSomeVar = true;
                    } else {
                        res.append(str.substring(first, end + 1));
                    }
                    pos = end + 1;
                    if (pos < str.length()) continue;
                    pos = -1;
                    continue;
                }
                if (pos == 0) {
                    return null;
                }
                res.append(str.substring(pos));
                pos = -1;
                continue;
            }
            if (pos == 0) {
                return null;
            }
            res.append(str.substring(pos));
            pos = -1;
        } while (pos != -1);
        if (!resolvedSomeVar) {
            return null;
        }
        return res.toString();
    }

    @Override
    public boolean resolve(Node node) {
        boolean resolvedSomeVar = false;
        if (node.hasAttributes()) {
            NamedNodeMap attribs = node.getAttributes();
            for (int i = 0; i < attribs.getLength(); ++i) {
                Attr attr = (Attr)attribs.item(i);
                String oldValue = attr.getValue();
                String newValue = this.resolve(oldValue);
                if (newValue == null) continue;
                attr.setValue(newValue);
                resolvedSomeVar = true;
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof CharacterData) {
                CharacterData textNode = (CharacterData)child;
                String oldValue = textNode.getData();
                String newValue = this.resolve(oldValue);
                if (newValue == null) continue;
                DOMUtilInternal.setCharacterDataContent(textNode, newValue);
                resolvedSomeVar = true;
                continue;
            }
            if (!this.resolve(child)) continue;
            resolvedSomeVar = true;
        }
        return resolvedSomeVar;
    }
}

