/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.tree;

import java.io.Serializable;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.comp.list.ListSelectionModelMgrImpl;
import org.itsnat.impl.comp.tree.EmptyTreeSelectionModelImpl;
import org.itsnat.impl.comp.tree.ItsNatTreeImpl;

public class TreeSelectionModelMgrImpl
implements TreeSelectionListener,
ListSelectionListener,
Serializable {
    protected ItsNatTreeImpl tree;
    protected TreeSelectionModel treeSelection;
    protected ListSelectionModelMgrImpl listSelMgr = new ListSelectionModelMgrImpl(new DefaultListSelectionModel());
    protected boolean synchTreeModelFromListModel = false;
    protected boolean synchListModelFromTreeModel = true;
    protected int currentMode = -1;

    public TreeSelectionModelMgrImpl(ItsNatTreeImpl tree, TreeSelectionModel treeSelection) {
        if (treeSelection == null) {
            treeSelection = EmptyTreeSelectionModelImpl.SINGLETON;
        }
        this.tree = tree;
        this.treeSelection = treeSelection;
        treeSelection.addTreeSelectionListener(this);
        this.listSelMgr.getListSelectionModel().addListSelectionListener(this);
        this.syncSelectionMode();
    }

    public void dispose() {
        this.treeSelection.removeTreeSelectionListener(this);
        this.listSelMgr.dispose();
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.treeSelection;
    }

    private ListSelectionModelMgrImpl getListSelectionModelMgr() {
        this.syncSelectionMode();
        return this.listSelMgr;
    }

    private void syncSelectionMode() {
        int newMode = this.treeSelection.getSelectionMode();
        if (this.currentMode != newMode) {
            int newListMode;
            this.currentMode = newMode;
            switch (newMode) {
                case 1: {
                    newListMode = 0;
                    break;
                }
                case 2: {
                    newListMode = 1;
                    break;
                }
                case 4: {
                    newListMode = 2;
                    break;
                }
                default: {
                    throw new ItsNatException("INTERNAL ERROR");
                }
            }
            this.listSelMgr.getListSelectionModel().setSelectionMode(newListMode);
        }
    }

    public void syncSelectionModelWithDataModel() {
        this.removeAllUpdateModel();
        int size = this.tree.getRowCount();
        this.getListSelectionModelMgr().syncWithDataModel(size);
    }

    public boolean isRowSelected(int row) {
        return this.getListSelectionModelMgr().getListSelectionModel().isSelectedIndex(row);
    }

    public void changeSelectionModel(int row, boolean toggle, boolean extend, boolean selected) {
        this.synchTreeModelFromListModel = true;
        this.getListSelectionModelMgr().changeSelectionModel(row, toggle, extend, selected);
        this.synchTreeModelFromListModel = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.tree.isExpandsSelectedPaths()) {
            TreePath[] paths = e.getPaths();
            for (int i = 0; i < paths.length; ++i) {
                this.tree.expandPath(paths[i]);
            }
        }
        if (!this.synchListModelFromTreeModel) {
            return;
        }
        boolean oldState = this.synchTreeModelFromListModel;
        this.synchTreeModelFromListModel = false;
        ListSelectionModelMgrImpl listSelModelMgr = this.getListSelectionModelMgr();
        ListSelectionModel listSelection = listSelModelMgr.getListSelectionModel();
        TreePath[] paths = e.getPaths();
        int[] rows = this.tree.getRowsForPaths(paths);
        boolean oldAdjusting = listSelection.getValueIsAdjusting();
        listSelection.setValueIsAdjusting(true);
        try {
            for (int i = 0; i < paths.length; ++i) {
                int row = rows[i];
                if (row >= 0) {
                    if (e.isAddedPath(i)) {
                        listSelModelMgr.addSelectionInterval(row, row);
                        continue;
                    }
                    listSelModelMgr.removeSelectionInterval(row, row);
                    continue;
                }
                throw new ItsNatException("A hidden node can not be selected/unselected", (Object)e);
            }
        }
        finally {
            listSelection.setValueIsAdjusting(false);
            listSelection.setValueIsAdjusting(oldAdjusting);
        }
        this.synchTreeModelFromListModel = oldState;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.synchTreeModelFromListModel) {
            return;
        }
        ListSelectionModel listSelection = this.getListSelectionModelMgr().getListSelectionModel();
        if (listSelection.getValueIsAdjusting()) {
            return;
        }
        boolean oldState = this.synchListModelFromTreeModel;
        this.synchListModelFromTreeModel = false;
        if (listSelection.isSelectionEmpty()) {
            this.treeSelection.clearSelection();
        } else if (this.treeSelection.getSelectionMode() == 2) {
            if (listSelection.isSelectionEmpty()) {
                this.treeSelection.clearSelection();
            } else {
                int first = listSelection.getMinSelectionIndex();
                int last = listSelection.getMaxSelectionIndex();
                TreePath[] paths = new TreePath[last - first + 1];
                for (int i = first; i <= last; ++i) {
                    TreePath path;
                    paths[i - first] = path = this.tree.getTreePathForRow(i);
                }
                this.treeSelection.setSelectionPaths(paths);
            }
        } else {
            int firstRow = e.getFirstIndex();
            int lastRow = e.getLastIndex();
            for (int i = firstRow; i <= lastRow; ++i) {
                TreePath path = this.tree.getTreePathForRow(i);
                boolean selected = listSelection.isSelectedIndex(i);
                if (selected) {
                    this.treeSelection.addSelectionPath(path);
                    continue;
                }
                this.treeSelection.removeSelectionPath(path);
            }
        }
        this.synchListModelFromTreeModel = oldState;
    }

    public void insertElementUpdateModel(int i, TreePath parentPath) {
        TreePath path = this.tree.toTreePath(i, parentPath);
        this.insertElementUpdateModel(path);
    }

    public void insertElementUpdateModel(TreePath path) {
        int row = this.tree.getRowForPath(path);
        if (row >= 0) {
            this.getListSelectionModelMgr().insertElementUpdateModel(row);
            this.insertAllChildElementsUpdateModel(path);
        }
    }

    public void insertAllChildElementsUpdateModel(TreePath parentPath) {
        Object parentNode = parentPath.getLastPathComponent();
        TreeModel dataModel = this.tree.getTreeModel();
        int len = dataModel.getChildCount(parentNode);
        for (int i = 0; i < len; ++i) {
            Object childNode = dataModel.getChild(parentNode, i);
            this.insertElementUpdateModel(i, parentPath);
        }
    }

    public void removeElementUpdateModel(int i, Object childNode, TreePath parentPath) {
        int parentRow = this.tree.getRowForPath(parentPath);
        if (parentRow == -1) {
            return;
        }
        TreePath childPath = parentPath.pathByAddingChild(childNode);
        int rows = this.tree.getRowCountSubTree(childPath);
        if (rows == 0) {
            return;
        }
        int rowStart = parentRow + i + 1;
        int rowEnd = rowStart + rows - 1;
        this.removeRangeUpdateModel(rowStart, rowEnd);
    }

    private void removeRangeUpdateModel(int rowStart, int rowEnd) {
        this.getListSelectionModelMgr().removeRangeUpdateModel(rowStart, rowEnd);
    }

    public void removeAllChildElementsUpdateModel(TreePath path) {
        if (path == null) {
            this.removeRootUpdateModel();
        } else {
            int rowEnd;
            int rowStart;
            TreePath prevPath = this.tree.getPreviousPath(path);
            if (prevPath == null) {
                int rootRow = this.tree.getRowForPath(path);
                if (rootRow == -1) {
                    return;
                }
                rowStart = 1;
                int rows = this.getListSelectionModelMgr().getSize();
                rowEnd = rows - 1;
                if (rowStart > rowEnd) {
                    return;
                }
            } else {
                int rowPrev = this.tree.getRowForPath(prevPath);
                if (rowPrev == -1) {
                    return;
                }
                rowStart = rowPrev + 2;
                TreePath nextPath = this.tree.getNextPath(path, false);
                if (nextPath != null) {
                    int rowNext = this.tree.getRowForPath(nextPath);
                    rowEnd = rowNext - 1;
                } else {
                    int rows = this.getListSelectionModelMgr().getSize();
                    rowEnd = rows - 1;
                    if (rowStart > rowEnd) {
                        return;
                    }
                }
            }
            this.removeRangeUpdateModel(rowStart, rowEnd);
        }
    }

    public void removeRootUpdateModel() {
        boolean syncTreeOld = this.synchTreeModelFromListModel;
        this.synchTreeModelFromListModel = false;
        this.getListSelectionModelMgr().removeAllUpdateModel();
        this.synchTreeModelFromListModel = syncTreeOld;
        boolean syncListOld = this.synchListModelFromTreeModel;
        this.synchListModelFromTreeModel = false;
        this.treeSelection.clearSelection();
        this.synchListModelFromTreeModel = syncListOld;
    }

    public void removeAllUpdateModel() {
        this.treeSelection.clearSelection();
    }
}

