/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.tree;

import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.itsnat.comp.ItsNatComponent;
import org.itsnat.comp.tree.ItsNatTreeCellEditor;
import org.itsnat.comp.tree.ItsNatTreeCellUI;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.comp.inplace.EditorProcessorBaseImpl;
import org.itsnat.impl.comp.tree.ItsNatTreeImpl;
import org.itsnat.impl.comp.tree.ItsNatTreeUIImpl;
import org.itsnat.impl.comp.tree.TreeSelectionModelMgrImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;

public class TreeCellEditorProcessor
extends EditorProcessorBaseImpl {
    protected ItsNatTreeCellUI cellInfo;
    protected TreePath path;
    protected int row;

    public TreeCellEditorProcessor(ItsNatTreeImpl compParent) {
        super(compParent);
    }

    public ItsNatTreeImpl getItsNatTree() {
        return (ItsNatTreeImpl)this.compParent;
    }

    public ItsNatTreeCellEditor getItsNatTreeCellEditor() {
        return (ItsNatTreeCellEditor)this.cellEditor;
    }

    public void setItsNatTreeCellEditor(ItsNatTreeCellEditor cellEditor) {
        this.setCellEditor(cellEditor);
    }

    public void setCurrentContext(ItsNatTreeCellUI cellInfo, TreePath path, int row) {
        this.cellInfo = cellInfo;
        this.path = path;
        this.row = row;
    }

    public TreePath getTreePath() {
        return this.path;
    }

    public int getRow() {
        return this.row;
    }

    public void startEdition(TreePath path) {
        if (this.prepareEdition()) {
            this.openEditor(path);
        }
    }

    public void startEdition(int row) {
        if (this.prepareEdition()) {
            this.openEditor(row);
        }
    }

    private void openEditor(TreePath path) {
        ItsNatTreeUIImpl compUI = this.getItsNatTree().getItsNatTreeUIImpl();
        ItsNatTreeCellUI cellInfo = compUI.getItsNatTreeCellUIFromTreePath(path);
        if (cellInfo == null) {
            throw new ItsNatException("This tree node cannot be edited, may be is the root node in a rootless tree");
        }
        this.openEditor(path, cellInfo.getRow(), cellInfo);
    }

    private void openEditor(int row) {
        ItsNatTreeUIImpl compUI = this.getItsNatTree().getItsNatTreeUIImpl();
        ItsNatTreeCellUI cellInfo = compUI.getItsNatTreeCellUIFromRow(row);
        this.openEditor(cellInfo.getTreePath(), row, cellInfo);
    }

    private void openEditor(ItsNatTreeCellUI cellInfo) {
        this.openEditor(cellInfo.getTreePath(), cellInfo.getRow(), cellInfo);
    }

    private void openEditor(TreePath path, int row, ItsNatTreeCellUI cellInfo) {
        if (row >= 0) {
            this.setCurrentContext(cellInfo, path, row);
            ItsNatTreeImpl tree = this.getItsNatTree();
            TreeModel dataModel = tree.getTreeModel();
            Element labelElem = cellInfo.getLabelElement();
            TreeSelectionModelMgrImpl selModelMgr = tree.getTreeSelectionModelMgr();
            boolean isSelected = selModelMgr.isRowSelected(row);
            Object dataNode = path.getLastPathComponent();
            boolean isLeaf = dataModel.isLeaf(dataNode);
            boolean expanded = cellInfo.isExpanded();
            this.beforeShow(labelElem);
            ItsNatTreeCellEditor cellEditor = this.getItsNatTreeCellEditor();
            ItsNatComponent compEditor = cellEditor.getTreeCellEditorComponent(tree, row, dataNode, isSelected, expanded, isLeaf, labelElem);
            this.afterShow(compEditor);
        }
    }

    @Override
    protected void openEditor(Event evt) {
        Node nodeClicked = (Node)((Object)evt.getTarget());
        ItsNatTreeUIImpl compUI = this.getItsNatTree().getItsNatTreeUIImpl();
        ItsNatTreeCellUI cellInfo = compUI.getItsNatTreeCellUIFromNode(nodeClicked);
        if (cellInfo != null && DOMUtilInternal.isChildOrSame(nodeClicked, cellInfo.getLabelElement(), cellInfo.getParentElement())) {
            this.openEditor(cellInfo);
        }
    }

    @Override
    public void acceptNewValue(Object value) {
        TreeModel dataModel = this.getItsNatTree().getTreeModel();
        dataModel.valueForPathChanged(this.path, value);
    }

    @Override
    public void clearCurrentContext() {
        this.setCurrentContext(null, null, -1);
    }
}

