/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.tree;

import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.itsnat.comp.tree.ItsNatTree;
import org.itsnat.comp.tree.ItsNatTreeCellRenderer;
import org.itsnat.comp.tree.ItsNatTreeCellUI;
import org.itsnat.comp.tree.ItsNatTreeStructure;
import org.itsnat.comp.tree.ItsNatTreeUI;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.domutil.ElementTreeNode;
import org.itsnat.core.domutil.ElementTreeNodeList;
import org.itsnat.impl.comp.ItsNatElementComponentUIImpl;
import org.itsnat.impl.comp.tree.DefaultRowMapperImpl;
import org.itsnat.impl.comp.tree.ItsNatTreeCellUIImpl;
import org.itsnat.impl.comp.tree.ItsNatTreeImpl;
import org.itsnat.impl.comp.tree.ItsNatTreeStructureCoreAdapterImpl;
import org.itsnat.impl.core.domutil.ElementGroupManagerImpl;
import org.itsnat.impl.core.domutil.ElementTreeNodeImpl;
import org.itsnat.impl.core.domutil.ElementTreeNodeListImpl;
import org.itsnat.impl.core.domutil.ElementTreeVersatileImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ItsNatTreeUIImpl
extends ItsNatElementComponentUIImpl
implements ItsNatTreeUI {
    protected boolean enabled = true;
    protected ElementTreeVersatileImpl elementTree;

    public ItsNatTreeUIImpl(ItsNatTreeImpl parentComp) {
        super(parentComp);
        Element parentElement = this.getElement();
        ItsNatTreeStructure structure = parentComp.getItsNatTreeStructure();
        ItsNatTreeStructureCoreAdapterImpl structAdapter = new ItsNatTreeStructureCoreAdapterImpl(structure, this);
        ElementGroupManagerImpl factory = this.getItsNatDocumentImpl().getElementGroupManagerImpl();
        this.elementTree = factory.createElementTreeVersatileInternal(parentComp.isRootless(), parentComp.isTreeTable(), parentElement, true, structAdapter, null);
    }

    @Override
    public ItsNatTree getItsNatTree() {
        return (ItsNatTree)((Object)this.parentComp);
    }

    public ItsNatTreeImpl getItsNatTreeImpl() {
        return (ItsNatTreeImpl)this.parentComp;
    }

    public RowMapper getRowMapper() {
        return this.getItsNatTree().getRowMapper();
    }

    public DefaultRowMapperImpl getDefaultRowMapper() {
        return this.getItsNatTreeImpl().getDefaultRowMapper();
    }

    public boolean isRootless() {
        return this.elementTree.isRootless();
    }

    public ItsNatTreeCellRenderer getItsNatTreeCellRenderer() {
        return this.getItsNatTree().getItsNatTreeCellRenderer();
    }

    public int logicToMarkupRow(int row) {
        if (this.isRootless()) {
            --row;
        }
        return row;
    }

    public int markupToLogicRow(int row) {
        if (this.isRootless()) {
            ++row;
        }
        return row;
    }

    public int getChildCount(ElementTreeNodeImpl treeNode) {
        return treeNode.getChildTreeNodeList().getLength();
    }

    public ItsNatTreeCellUI getChildItsNatTreeCellUIAt(int index, ElementTreeNodeImpl treeNode) {
        ElementTreeNodeImpl childTreeNode = (ElementTreeNodeImpl)treeNode.getChildTreeNodeList().getTreeNodeAt(index);
        return this.getItsNatTreeCellUI(childTreeNode);
    }

    @Override
    public Element getParentElementFromRow(int row) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromRow(row);
        if (treeNode == null) {
            return null;
        }
        return treeNode.getParentElement();
    }

    public Element getContentElement(ElementTreeNodeImpl treeNode) {
        ItsNatTree tree = this.getItsNatTree();
        ItsNatTreeStructure structure = tree.getItsNatTreeStructure();
        return structure.getContentElement(tree, this.getRow(treeNode), treeNode.getParentElement());
    }

    public Element getHandleElement(ElementTreeNodeImpl treeNode) {
        ItsNatTree tree = this.getItsNatTree();
        ItsNatTreeStructure structure = tree.getItsNatTreeStructure();
        return structure.getHandleElement(tree, this.getRow(treeNode), treeNode.getParentElement());
    }

    public Element getIconElement(ElementTreeNodeImpl treeNode) {
        ItsNatTree tree = this.getItsNatTree();
        ItsNatTreeStructure structure = tree.getItsNatTreeStructure();
        return structure.getIconElement(tree, this.getRow(treeNode), treeNode.getParentElement());
    }

    public Element getLabelElement(ElementTreeNodeImpl treeNode) {
        ItsNatTree tree = this.getItsNatTree();
        ItsNatTreeStructure structure = tree.getItsNatTreeStructure();
        return structure.getLabelElement(tree, this.getRow(treeNode), treeNode.getParentElement());
    }

    @Override
    public Element getContentElementFromRow(int row) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromRow(row);
        if (treeNode == null) {
            return null;
        }
        return this.getContentElement(treeNode);
    }

    @Override
    public Element getHandleElementFromRow(int row) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromRow(row);
        if (treeNode == null) {
            return null;
        }
        return this.getHandleElement(treeNode);
    }

    @Override
    public Element getIconElementFromRow(int row) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromRow(row);
        if (treeNode == null) {
            return null;
        }
        return this.getIconElement(treeNode);
    }

    @Override
    public Element getLabelElementFromRow(int row) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromRow(row);
        if (treeNode == null) {
            return null;
        }
        return this.getLabelElement(treeNode);
    }

    @Override
    public Element getContentElementFromTreePath(TreePath path) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromTreePath(path);
        if (treeNode == null) {
            return null;
        }
        return this.getContentElement(treeNode);
    }

    @Override
    public Element getParentElementFromTreePath(TreePath path) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromTreePath(path);
        if (treeNode == null) {
            return null;
        }
        return treeNode.getParentElement();
    }

    @Override
    public Element getHandleElementFromTreePath(TreePath path) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromTreePath(path);
        if (treeNode == null) {
            return null;
        }
        return this.getHandleElement(treeNode);
    }

    @Override
    public Element getIconElementFromTreePath(TreePath path) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromTreePath(path);
        if (treeNode == null) {
            return null;
        }
        return this.getIconElement(treeNode);
    }

    @Override
    public Element getLabelElementFromTreePath(TreePath path) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromTreePath(path);
        if (treeNode == null) {
            return null;
        }
        return this.getLabelElement(treeNode);
    }

    public int getRow(ElementTreeNodeImpl treeNode) {
        int row = treeNode.getRow();
        return this.markupToLogicRow(row);
    }

    public int getRowCount(ElementTreeNodeImpl treeNode) {
        return treeNode.getRowCount();
    }

    @Override
    public int getRowCount() {
        int count = this.elementTree.getRowCount();
        return this.markupToLogicRow(count);
    }

    @Override
    public int getRowCount(TreePath path) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromTreePath(path);
        return this.getRowCount(treeNode);
    }

    @Override
    public int getRow(TreePath path) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromTreePath(path);
        return this.getRow(treeNode);
    }

    @Override
    public int getRow(int index, TreePath parentPath) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromTreePath(index, parentPath);
        return this.getRow(treeNode);
    }

    @Override
    public int getRowCount(int index, TreePath parentPath) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromTreePath(index, parentPath);
        return this.getRowCount(treeNode);
    }

    public ElementTreeNodeImpl getElementTreeNodeFromRow(int row) {
        row = this.logicToMarkupRow(row);
        return this.elementTree.getElementTreeNodeFromRow(row);
    }

    @Override
    public ItsNatTreeCellUI getItsNatTreeCellUIFromNode(Node node) {
        ElementTreeNodeImpl treeNode = this.elementTree.getElementTreeNodeFromNode(node);
        return this.getItsNatTreeCellUI(treeNode);
    }

    @Override
    public ItsNatTreeCellUI getItsNatTreeCellUIFromTreePath(TreePath path) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromTreePath(path);
        return this.getItsNatTreeCellUI(treeNode);
    }

    @Override
    public ItsNatTreeCellUI getItsNatTreeCellUIFromRow(int row) {
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromRow(row);
        return this.getItsNatTreeCellUI(treeNode);
    }

    public ItsNatTreeCellUIImpl getItsNatTreeCellUI(ElementTreeNodeImpl treeNode) {
        if (treeNode == null) {
            return null;
        }
        return ItsNatTreeCellUIImpl.getItsNatTreeCellUI(this, treeNode);
    }

    public ElementTreeNodeImpl getElementTreeNodeFromTreePath(TreePath path) {
        if (path == null) {
            return null;
        }
        return this.getElementTreeNodeFromRow(this.getDefaultRowMapper().getRowForPath(path));
    }

    public ElementTreeNodeImpl getElementTreeNodeFromTreePath(int index, TreePath parentPath) {
        ElementTreeNodeListImpl childList = this.getElementTreeNodeChildList(parentPath);
        return (ElementTreeNodeImpl)childList.getTreeNodeAt(index);
    }

    public ElementTreeNodeListImpl getElementTreeNodeChildList(TreePath path) {
        if (path.getParentPath() == null && this.isRootless()) {
            return this.elementTree.getChildListRootless();
        }
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromTreePath(path);
        return treeNode.getElementTreeNodeList();
    }

    public void insertTreeNodeAt(TreePath path) {
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            this.addRootNode(path);
        } else {
            TreeModel dataModel = this.getItsNatTree().getTreeModel();
            int index = dataModel.getIndexOfChild(parentPath.getLastPathComponent(), path.getLastPathComponent());
            ElementTreeNodeImpl parentTreeNode = this.getElementTreeNodeFromTreePath(parentPath);
            this.insertElementAt(index, path, parentTreeNode);
        }
    }

    public void insertTreeNodeAt(int index, TreePath parentPath) {
        ElementTreeNodeListImpl treeNodeListParent = this.getElementTreeNodeChildList(parentPath);
        TreeModel dataModel = this.getItsNatTree().getTreeModel();
        Object dataNode = dataModel.getChild(parentPath.getLastPathComponent(), index);
        TreePath path = parentPath.pathByAddingChild(dataNode);
        this.insertElementAt(index, path, treeNodeListParent);
    }

    public void removeTreeNodeAt(int index, TreePath parentPath) {
        ElementTreeNodeListImpl treeNodeListParent = this.getElementTreeNodeChildList(parentPath);
        this.removeElementAt(index, treeNodeListParent);
    }

    public void removeAllChildTreeNodes(TreePath parentPath) {
        if (parentPath == null) {
            this.removeRootNode();
        } else {
            ElementTreeNodeImpl parentTreeNode = this.getElementTreeNodeFromTreePath(parentPath);
            ElementTreeNodeListImpl treeNodeListParent = (ElementTreeNodeListImpl)parentTreeNode.getChildTreeNodeList();
            int len = treeNodeListParent.getLength();
            for (int i = 0; i < len; ++i) {
                this.removeElementAt(0, treeNodeListParent);
            }
        }
    }

    public void setNodeValueAt(TreePath path, boolean hasFocus, ElementTreeNodeImpl treeNode, boolean isNew) {
        int row = this.getDefaultRowMapper().getRowForPath(path);
        if (row < 0) {
            throw new ItsNatException("Tree node is not shown: " + path, (Object)treeNode);
        }
        Object dataNode = path.getLastPathComponent();
        this.setNodeValueAt(row, dataNode, hasFocus, treeNode, isNew);
    }

    public void setTreeNodeValueAt(int index, TreePath parentPath, boolean hasFocus) {
        TreePath path = this.getItsNatTreeImpl().toTreePath(index, parentPath);
        this.setTreeNodeValueAt(path, hasFocus);
    }

    public void setTreeNodeValueAt(TreePath path, boolean hasFocus) {
        int row = this.getDefaultRowMapper().getRowForPath(path);
        if (row == 0 && this.isRootless()) {
            return;
        }
        ElementTreeNodeImpl treeNode = this.getElementTreeNodeFromRow(row);
        Object value = path.getLastPathComponent();
        this.setNodeValueAt(row, value, hasFocus, treeNode, false);
    }

    public void setNodeValueAt(int row, Object value, boolean hasFocus, ElementTreeNodeImpl treeNode, boolean isNew) {
        ItsNatTree tree = this.getItsNatTree();
        TreeModel dataModel = tree.getTreeModel();
        boolean isSelected = tree.getTreeSelectionModel().isRowSelected(row);
        boolean isLeaf = dataModel.isLeaf(value);
        boolean expanded = this.getItsNatTreeCellUI(treeNode).isExpanded();
        Element treeNodeLabelElem = treeNode.getLabelElement();
        treeNode.setUsePatternMarkupToRender(this.isUsePatternMarkupToRender());
        treeNode.prepareRendering(treeNodeLabelElem, isNew);
        ItsNatTreeCellRenderer renderer = this.getItsNatTreeCellRenderer();
        if (renderer != null) {
            renderer.renderTreeCell(tree, row, value, isSelected, expanded, isLeaf, hasFocus, treeNodeLabelElem, isNew);
        }
    }

    public void removeElementAt(int index, ElementTreeNodeListImpl treeNodeListParent) {
        this.unrenderTreeNode(index, treeNodeListParent);
        treeNodeListParent.removeTreeNodeAt(index);
    }

    public void insertElementAt(int index, TreePath path, ElementTreeNode treeNodeParent) {
        this.insertElementAt(index, path, treeNodeParent.getChildTreeNodeList());
    }

    public void insertElementAt(int index, TreePath path, ElementTreeNodeList treeNodeList) {
        ElementTreeNode newTreeNode = treeNodeList.insertTreeNodeAt(index);
        this.setNodeValueAt(path, false, (ElementTreeNodeImpl)newTreeNode, true);
        this.insertChildren(path, newTreeNode.getChildTreeNodeList());
    }

    public void insertChildren(TreePath path, ElementTreeNodeList treeNodeList) {
        TreeModel dataModel = this.getItsNatTree().getTreeModel();
        Object dataNode = path.getLastPathComponent();
        int count = dataModel.getChildCount(dataNode);
        for (int i = 0; i < count; ++i) {
            Object childNode = dataModel.getChild(dataNode, i);
            TreePath childPath = path.pathByAddingChild(childNode);
            this.insertElementAt(i, childPath, treeNodeList);
        }
    }

    public void addRootNode(Object dataNodeRoot) {
        TreePath rootPath = new TreePath(dataNodeRoot);
        this.addRootNode(rootPath);
    }

    public void addRootNode(TreePath rootPath) {
        if (!this.isRootless()) {
            ElementTreeNodeImpl rootNode = this.elementTree.addRootNode();
            this.setNodeValueAt(rootPath, false, rootNode, true);
        }
        ElementTreeNodeListImpl treeNodeList = this.getElementTreeNodeChildList(rootPath);
        this.insertChildren(rootPath, treeNodeList);
    }

    public void unrenderTreeNode(int index, ElementTreeNodeListImpl childList) {
        ElementTreeNodeImpl treeNode = (ElementTreeNodeImpl)childList.getTreeNodeAt(index);
        this.unrenderTreeNode(treeNode);
    }

    public void unrenderTreeNode(ElementTreeNodeImpl treeNode) {
        if (treeNode == null) {
            return;
        }
        ItsNatTreeCellRenderer renderer = this.getItsNatTreeCellRenderer();
        if (renderer != null) {
            Element treeNodeLabelElem = treeNode.getLabelElement();
            renderer.unrenderTreeCell(this.getItsNatTree(), treeNode.getRow(), treeNodeLabelElem);
        }
        ElementTreeNodeListImpl childList = treeNode.getElementTreeNodeList();
        this.unrenderTreeNode(childList);
    }

    public void unrenderTreeNode(ElementTreeNodeListImpl childList) {
        if (childList == null) {
            return;
        }
        int len = childList.getLength();
        for (int i = 0; i < len; ++i) {
            this.unrenderTreeNode(i, childList);
        }
    }

    public void removeRootNode() {
        if (!this.isRootless()) {
            this.unrenderTreeNode(this.elementTree.getRootNode());
        } else {
            this.unrenderTreeNode(this.elementTree.getChildListRootless());
        }
        this.elementTree.removeRootNode();
    }

    @Override
    public boolean isUsePatternMarkupToRender() {
        return this.elementTree.isUsePatternMarkupToRender();
    }

    @Override
    public void setUsePatternMarkupToRender(boolean value) {
        this.elementTree.setUsePatternMarkupToRender(value);
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

